/*
 *  Wrapper base class for all data structures
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "simplewrapper.h"

using namespace KDE::GST;

QMap<void*,SimpleWrapper*> SimpleWrapper::instanceMap;


SimpleWrapper::SimpleWrapper(void *real) :
	m_real(real)
{
	addToMap();
}

SimpleWrapper::~SimpleWrapper() {
	removeFromMap();
}

SimpleWrapper* SimpleWrapper::wrap(void *real) {
	if (!real)
		return 0;
	QMap<void*,SimpleWrapper*>::iterator i = instanceMap.find(real);
	if (i == instanceMap.end())
		return new SimpleWrapper(real);
	return i.data();
}

void SimpleWrapper::addToMap() {
	if (m_real)
		instanceMap.insert(m_real, this, false);
}

void SimpleWrapper::removeFromMap() {
	if (m_real)
		instanceMap.remove(m_real);
}

void *SimpleWrapper::disassociate() {
	void *obj = m_real;
	removeFromMap();
	m_real = 0;
	delete this;
	return obj;
}

void *SimpleWrapper::realObject() const {
	return m_real;
}
	
