/*
 *  Wrapper base class for all data structures
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef KDE_GST_SIMPLEWRAPPER_H
#define KDE_GST_SIMPLEWRAPPER_H

#include <qmap.h>

namespace KDE {
namespace GST {

/**
 * SimpleWrapper is used as a base class to wrap simple objects/structs
 * that do not inherit from GObject.
 * @short Base class for simple objects and structs.
 * @see Wrapper
 */
	class SimpleWrapper {
	private:
		void *reserved;
			
	protected:
		/**
		 * Pointer to the object.
		 */
	        void *m_real;
	        static QMap<void*,SimpleWrapper*> instanceMap;

		void removeFromMap();
		void addToMap();

		void *d;

	public:
/**
 * Creates a new SimpleWrapper that wrapps the given object or struct.
 * You must never create a object of this class on the stack, always 
 * use new.
 * @param real the object to be wrapped.
 */
	        SimpleWrapper(void *real);
	        virtual ~SimpleWrapper();

/**
 * Creates a new SimpleWrapper that wrapps the given object. Unlike the
 * constructor this re-used already existing objects.
 * @param real the object to be wrapped
 * @return the SimpleWrapper
 */
		static SimpleWrapper* wrap(void *real);

/**
 * Returns the original object that is wrapped. You need to cast it to the 
 * appropriate type.
 * @return the wrapped object
 */
		void *realObject() const;		

/**
 * Deletes the wrapper object without deleting the real object. 
 * @return the real GStreamer object
 */
		void *disassociate();
	
	};
}
}

#endif
