/*
 *  Interface/wrapper for GStreamer GstThread
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *  API Documentation
 *  Copyright (C) 1999,2000 Erik Walthinsen <omega@cse.ogi.edu>
 *                     2000 Wim Taymans <wtay@chello.be>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef KDE_GST_THREAD_H
#define KDE_GST_THREAD_H

#include <kde/gst/bin.h>

namespace KDE {
namespace GST {

/**
 * A bin that will become a thread if possible when the pipeline is started
 * up. It can contain any set of Objects. 
 * A Thread can act as a toplevel bin as it has its own scheduler.
 * 
 * @short A bin that will become a thread
 * @see Bin
 * @see Pipeline
 */
	class Thread : public Bin {
	Q_OBJECT
	private:
                friend class GStreamer;
                static Wrapper* wrapperFactory(void *real);
		void *reserved;
		
	public:
		enum ThreadState {
			STATE_STARTED	= Bin::FLAG_LAST,
			STATE_SPINNING,
			STATE_REAPING,
			/* padding */
			FLAG_LAST 	= Bin::FLAG_LAST + 4
		};
		
/**
 * Creates a new Thread that wrapps the given GstThread. Usually
 * you really don't want to call this, use @ref #wrap instead.
 * You must not create a object of this class on the stack, always 
 * use new.
 * @param real the GstThread to be wrapped
 */
	        Thread(void *real);
	        virtual ~Thread();

/**
 * Creates a new Thread that wrapps the given GstThread
 * If there is already a wrapper object it will be re-used. 
 *
 * @param real the GstThread to be wrapped
 * @return the wrapped Thread (or derivative)
 */
		static Thread* wrap(void *real);

/**
 * Create a new Thread with given name.
 *
 * @param name name of new Thread (or QString::null for auto naming)
 */
		Thread(const QString &name = QString::null);
	};
}
}

#endif
