/*
 *  Wrapper base class for GstType
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "type.h"
#include "helper.h"

extern "C" {
#include <gst/gst.h>
}

using namespace KDE::GST;


#define r() ((GstType*)m_real)

Type::Type(void *real) :
	SimpleWrapper(real) {
}

Type::~Type() {
}

Type* Type::wrap(void *real) {
	return (Type*) SimpleWrapper::wrap(real);
}

unsigned short Type::id() const {
	return r()->id;
}

QString Type::mime() const {
	return QString(r()->mime);
}

QString Type::extensions() const {
	return QString(r()->exts);
}

unsigned short Type::findByMime(const QString &mime) {
	return gst_type_find_by_mime(mime.latin1());
}

unsigned short Type::findByExt(const QString &ext) {
	return gst_type_find_by_ext(ext.latin1());
}

Type* Type::findById(unsigned short id) {
	return wrap(gst_type_find_by_id(id));
}

QValueVector<Type*> Type::getList() {
	return convertList<Type>(gst_type_get_list());
}
