/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef KHALKHI_PROPERTYADAPTER_H
#define KHALKHI_PROPERTYADAPTER_H


// qt specific
#include <qobject.h>
// lib specific
#include "propertyitem.h"

class QString;
namespace KABC {
class Addressee;
class AddresseeList;
}


namespace Khalkhi {

class KDE_EXPORT PropertyAdapter : public QObject
{
    Q_OBJECT
protected:
    PropertyAdapter( QObject* Parent, const char* Name, const QStringList& Arguments );
public:
    virtual ~PropertyAdapter();
public:
    const QString &id() const;

public:
    // if some TODO: or better only all?
    virtual bool haveProperty( const KABC::AddresseeList &PersonList ) const;

    /** returns  */
    virtual int numberOfItems( const KABC::Addressee &Person ) const = 0;

    virtual PropertyItem propertyItemOf( const KABC::Addressee &Person, int ItemIndex = 0 ) const = 0;

private:
    const QString Id;
};

}

#endif
