/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef KHALKHI_PROPERTYDATAACTIONSERVICE_H
#define KHALKHI_PROPERTYDATAACTIONSERVICE_H


// lib specific
#include "serviceaction.h"
#include "propertyservice.h"

class QMimeSource;
namespace KABC { class Addressee; }


namespace Khalkhi {

class PropertyDataActionServiceClient;


class KDE_EXPORT PropertyDataActionService : public PropertyService
{
    Q_OBJECT
public:
    PropertyDataActionService( QObject *Parent, const char *Name, const QStringList &Arguments );
    virtual ~PropertyDataActionService();

public: // interface
    virtual ServiceAction action( const KABC::Addressee &Person, int ItemIndex,
                                  QMimeSource *Data, int Flags ) const = 0;

    /** does the service on the item with the given index from the supported person type */
    virtual void execute( const KABC::Addressee &Person, int ItemIndex, QMimeSource *Data ) = 0;

    /** @returns if the service is possible for the item; defaults to return true */
    virtual bool supports( QMimeSource *Data ) const;
    virtual bool supports( QMimeSource *Data, const KABC::Addressee &Person, int ItemIndex ) const;

    /** @returns if the service is available currently; defaults to return true */
    virtual bool isAvailableFor( QMimeSource *Data ) const;
    /** @returns if the service is available currently for the item; defaults to return true */
    virtual bool isAvailableFor( QMimeSource *Data, const KABC::Addressee &Person, int ItemIndex ) const;

    /** if ItemIndex = -1 register all items */
    virtual void registerClient( PropertyDataActionServiceClient *Client, int ItemIndex = -1 );
    virtual void unregisterClient( PropertyDataActionServiceClient *Client, int ItemIndex = -1 );
};

}

#endif
