/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// qt specific
#include <qsignalmapper.h>
// kde
#include <kxmlguiclient.h>
// khalkhi core
#include <services.h>
#include <propertyadapter.h>
// lib specific
#include "allpropertiesglobalactionservicexmlguifiller.h"


namespace Khalkhi {

AllPropertiesGlobalActionServiceXMLGUIFiller::AllPropertiesGlobalActionServiceXMLGUIFiller()
 : Client( 0 ), SignalMapper( new QSignalMapper(this) )
{
    connect( SignalMapper, SIGNAL(mapped( int )), SLOT(onActionActivation( int )) );
}

const KABC::Addressee &AllPropertiesGlobalActionServiceXMLGUIFiller::person() const { return Person; }

void AllPropertiesGlobalActionServiceXMLGUIFiller::onGlobalActionServiceSwitch( const QString &/*PropertyId*/ ) { /*TODO: what to do?*/}
void AllPropertiesGlobalActionServiceXMLGUIFiller::onPropertyManagerChange() { /*TODO: what to do?*/}

void AllPropertiesGlobalActionServiceXMLGUIFiller::onActionServiceStateChange( const PropertyActionService &Service,
                                                                              int /*Change*/, int ItemIndex )
{
    const QString &ServiceId = Service.id();

    int MaxItemIndex;
    if( ItemIndex == -1 )
    {
        ItemIndex = 0;
        MaxItemIndex = Service.adapter()->numberOfItems( Person );
    }
    else
        MaxItemIndex = ItemIndex+1;

    for( ; ItemIndex<MaxItemIndex; ++ItemIndex )
    {
        // find menuid of action
        int Flags;
        int ActionId = IdActionMap.menuId( Service.adapter()->id(), ItemIndex, ServiceId, &Flags );

        if( ActionId != -1 )
        {
            // TODO: store (refer item) flag in IdActionMap
            ServiceAction Action = Service.action( Person, ItemIndex, Flags );

            QString Entry = Action.data( DisplayTextRole ).asString();
            QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
            bool Enabled = Action.data( EnabledRole ).asBool();

            KAction *GUIAction = Actions.at( ActionId );

            GUIAction->setIconSet( IconSet );
            GUIAction->setText( Entry );
            GUIAction->setEnabled( Enabled );
        }
    }
}

void AllPropertiesGlobalActionServiceXMLGUIFiller::setGUIClient( KXMLGUIClient *C, const QString &LI )
{
    Client = C;
    ListId = LI;

    if( Client == 0 )
        Services::self()->unregisterClient( this );
}

void AllPropertiesGlobalActionServiceXMLGUIFiller::setPerson( const KABC::Addressee& C )
{
    Services::self()->unregisterClient( this );

    Person = C;

    Services::self()->registerClient( this );

    update();
}

void AllPropertiesGlobalActionServiceXMLGUIFiller::update()
{
    const PropertyManagerList &Managers = Services::self()->propertyManagers();

    Actions.clear();
    int ActionId = 0;
    IdActionMap.prepare( Managers.size() );
    PropertyManagerList::ConstIterator ManagerIt = Managers.begin();
    for( ; ManagerIt != Managers.end(); ++ManagerIt )
    {
        const PropertyManager &Manager = **ManagerIt;

        const PropertyActionServiceList &Services = Manager.mainActionServices();
        if( Services.size() == 0 )
            continue;

        const PropertyAdapter *Adapter = Manager.propertyAdapter();
        const int ItemsSize = Adapter->numberOfItems( Person );
        if( ItemsSize == 0 )
            continue;

        IdActionMap.addProperty( Adapter->id(), Services.size() );

        for( PropertyActionServiceList::ConstIterator ServiceIt = Services.begin(); ServiceIt != Services.end(); ++ServiceIt )
        {
            const PropertyActionService &Service = **ServiceIt;

            if( !Service.isAvailable() )
                ;// TODO: 
            else
            {
                // find if properties have to be referenced
                int SupportedItems = 0;
                for( int ItemIndex = 0; ItemIndex<ItemsSize; ++ItemIndex )
                    if( Service.supports(Person,ItemIndex) )
                        SupportedItems++;
                if( SupportedItems == 0 )
                    continue;

                int Flags = PropertyService::Always;
                if( SupportedItems > 1 )
                    Flags |= PropertyService::ReferItem;

                IdActionMap.addService( Service.id(), ItemsSize );

                // insert service action entries
                for( int ItemIndex = 0; ItemIndex<ItemsSize; ++ItemIndex )
                {
                    if( Service.supports(Person,ItemIndex) )
                    {
                        IdActionMap.addItem( ItemIndex, ActionId, Flags );

                        ServiceAction Action = Service.action( Person, ItemIndex, Flags );

                        QString Entry = Action.data( DisplayTextRole ).asString();
                        QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
                        bool Enabled = Action.data( EnabledRole ).asBool();

                        KAction *GUIAction =
                            new KAction( Entry, IconSet, KShortcut(), SignalMapper, SLOT(map()),
                                         (KActionCollection*)0, 0 );
                        GUIAction->setEnabled( Enabled );
                        SignalMapper->setMapping( GUIAction, ActionId );
                        ++ActionId;
                        Actions.append( GUIAction );
                    }
                }
            }
        }
    }

    Client->unplugActionList( ListId );
    Client->plugActionList( ListId, Actions );
}

void AllPropertiesGlobalActionServiceXMLGUIFiller::onActionActivation( int ActionId )
{
    QString PropertyId;
    int ItemIndex;
    QString ServiceId;

    if( IdActionMap.remap(&PropertyId,&ItemIndex,&ServiceId, ActionId) )
        Services::self()->execute( Person, PropertyId, ItemIndex, ServiceId );
}

AllPropertiesGlobalActionServiceXMLGUIFiller::~AllPropertiesGlobalActionServiceXMLGUIFiller() {}

}

#include "allpropertiesglobalactionservicexmlguifiller.moc"
