/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// qt specific
#include <qstring.h>
// applet specific
#include "idserviceactionmap.h"


void IdServiceActionMap::addProperty( const QString &PropertyId, int Size )
{
    // previous entry used?
    if( PropertyMap.empty() || PropertyMap.last().ServiceMap.size() > 0 )
        // new entry
        PropertyMap.append( PropertyServiceItemMap(PropertyId) );
    else
        // reuse previous entry
        PropertyMap.last() = PropertyServiceItemMap( PropertyId );
    PropertyMap.last().ServiceMap.reserve( Size );
}

void IdServiceActionMap::addService( const QString ServiceId, int Size )
{
    // previous entry used?
    if( PropertyMap.last().ServiceMap.empty() || PropertyMap.last().ServiceMap.last().ItemMap.size() > 0 )
        // new entry
        PropertyMap.last().ServiceMap.append( ServiceItemMap(ServiceId) );
    else
        // reuse previous entry
        PropertyMap.last().ServiceMap.last() = ServiceItemMap( ServiceId );
    PropertyMap.last().ServiceMap.last().ItemMap.reserve( Size );
}

void IdServiceActionMap::addItem( int ItemIndex, int MenuId, int Flag )
{
  PropertyMap.last().ServiceMap.last().ItemMap.append( ItemMenuMap(ItemIndex,MenuId,Flag) );
}

bool IdServiceActionMap::remap( QString *PropertyId, int *ItemIndex, QString *ServiceId, int MenuId ) const
{
    bool Remapped = false;
    int p = PropertyMap.size()-1;
    // last not filled?
    if( PropertyMap[p].ServiceMap.size() == 0 )
        --p;
    for( ; p>=0 ; --p )
    {
        if( PropertyMap[p].ServiceMap.first().ItemMap.size() == 0 )
            continue;
        if( MenuId >= PropertyMap[p].ServiceMap.first().ItemMap.first().MenuId )
        {
            int s = PropertyMap[p].ServiceMap.size()-1;
            // last not filled?
            if( PropertyMap[p].ServiceMap[s].ItemMap.size() == 0 )
                --s;
            for( ; s>=0 ; --s )
            {
                if( MenuId >= PropertyMap[p].ServiceMap[s].ItemMap.first().MenuId )
                {
                    for( int i = PropertyMap[p].ServiceMap[s].ItemMap.size()-1; i>=0 ; --i )
                    {
                        if( MenuId == PropertyMap[p].ServiceMap[s].ItemMap[i].MenuId )
                        {
                            *PropertyId = PropertyMap[p].Id;
                            *ItemIndex =  PropertyMap[p].ServiceMap[s].ItemMap[i].Index;
                            *ServiceId =  PropertyMap[p].ServiceMap[s].Id;
                            Remapped = true;
                            break;
                        }
                    }
                    break;
                }
            }
            break;
        }
    }
    return Remapped;
}


int IdServiceActionMap::menuId( const QString &PropertyId, int ItemIndex, const QString &ServiceId,
                                int *Flag ) const
{
    int MenuId = -1;
    for( uint p=0; p<PropertyMap.size(); ++p )
        if( PropertyId == PropertyMap[p].Id )
        {
            for( uint s=0; s<PropertyMap[p].ServiceMap.size(); ++s )
                if( ServiceId == PropertyMap[p].ServiceMap[s].Id )
                {
                    for( uint i=0; i<PropertyMap[p].ServiceMap[s].ItemMap.size(); ++i )
                        if( ItemIndex == PropertyMap[p].ServiceMap[s].ItemMap[i].Index )
                        {
                            MenuId = PropertyMap[p].ServiceMap[s].ItemMap[i].MenuId;
                            if( Flag )
                                *Flag = PropertyMap[p].ServiceMap[s].ItemMap[i].Flag;
                            break;
                        }
                }
        }

    return MenuId;
}
