/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef IDSERVICEACTIONMAP_H
#define IDSERVICEACTIONMAP_H


// qt specific
#include <qvaluevector.h>

class QString;


struct ItemMenuMap
{
    ItemMenuMap() {}
    ItemMenuMap( int I, int Id, int F ) : Index( I ), MenuId( Id ), Flag( F ) {}
    int Index;
    int MenuId;
    int Flag;
};
struct ServiceItemMap
{
    ServiceItemMap() {}
    ServiceItemMap( const QString I ) : Id( I ) {}
    QString Id;
    QValueVector<ItemMenuMap> ItemMap;
};
struct PropertyServiceItemMap
{
    PropertyServiceItemMap() {}
    PropertyServiceItemMap( const QString I ) : Id( I ) {}
    QString Id;
    QValueVector<ServiceItemMap> ServiceMap;
};

class IdServiceActionMap
{
public:
    IdServiceActionMap();
    ~IdServiceActionMap();

public:
    void prepare( int Size );
    void addProperty( const QString &PropertyId, int Size );
    void addService( const QString ServiceId, int Size );
    void addItem( int ItemIndex, int MenuId, int Flag );

    bool remap( QString *PropertyId, int *ItemIndex, QString *ServiceId, int MenuId ) const;
    int menuId( const QString &PropertyId, int ItemIndex, const QString &ServiceId, int *Flag = 0 ) const;

protected:
    QValueVector<PropertyServiceItemMap> PropertyMap;
};


inline IdServiceActionMap::IdServiceActionMap() {}
inline IdServiceActionMap::~IdServiceActionMap() {}

inline void IdServiceActionMap::prepare( int Size )
{ PropertyMap.clear(); PropertyMap.reserve( Size ); }

#endif
