/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef MULTIACTIONSERVICEMENUFILLER_H
#define MULTIACTIONSERVICEMENUFILLER_H


// qt specific
#include <qobject.h>
#include <qstringlist.h>
// kde specific
#include <kabc/addresseelist.h>
// khalkhi core
#include "listactionserviceclient.h"

class QPopupMenu;

namespace Khalkhi {

class KDE_EXPORT ListActionServiceMenuFiller : public QObject, public ListActionServiceClient
{
    Q_OBJECT
public:
    ListActionServiceMenuFiller();
    virtual ~ListActionServiceMenuFiller();

public:
    void setPersonList( const KABC::AddresseeList& List );
    void setContext( const char *Context );
public:
    int fillMenu( QPopupMenu *Menu, int BaseMenuId  );

public: // ListActionServiceClient API
    virtual const KABC::AddresseeList &personList() const;
    virtual void onActionServiceStateChange( const ListActionService &Service, int Change );

protected slots:
    void onMenuSelection( int Id );
    void onMenuDestruction();

protected:
    QString Context;
    KABC::AddresseeList PersonList;

    QPopupMenu *Menu;
    int BaseMenuId;
    QStringList MenuServiceIds;
};

}

#endif
