/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef LISTALLPROPERTIESDEFAULTACTIONSERVICEXMLGUIFILLER_H
#define LISTALLPROPERTIESDEFAULTACTIONSERVICEXMLGUIFILLER_H


// qt specific
#include <qobject.h>
#include <qptrlist.h>
// kde specific
#include <kaction.h>
#include <kabc/addresseelist.h>
// khalkhi core
#include "listallpropertiesglobalactionserviceclient.h"
// lib specific
#include "idserviceactionmap.h"

class QSignalMapper;
class KXMLGUIClient;

namespace Khalkhi {

class KDE_EXPORT ListAllPropertiesGlobalActionServiceXMLGUIFiller : public QObject, public ListAllPropertiesGlobalActionServiceClient
{
    Q_OBJECT
public:
    ListAllPropertiesGlobalActionServiceXMLGUIFiller();
    virtual ~ListAllPropertiesGlobalActionServiceXMLGUIFiller();

public:
    void setPersonList( const KABC::AddresseeList& List );
    void setGUIClient( KXMLGUIClient *C, const QString &LI );
    void update();

public: // GlobalServiceClient interface
    virtual void onGlobalActionServiceSwitch( const QString &PropertyId );
    virtual void onPropertyManagerChange();

public: // ServiceClient interface
    virtual const KABC::AddresseeList &personList() const;
    virtual void onActionServiceStateChange( const PropertyActionService &Service, int Change,
                                             int ItemIndex );

protected slots:
    void onActionActivation( int Id );

protected:
    KABC::AddresseeList PersonList;

    KXMLGUIClient *Client;
    QString ListId;

    QPtrList<KAction> Actions;
    QSignalMapper *SignalMapper;
    IdServiceActionMap IdActionMap;
};

}

#endif
