/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/

// khalkhicore
#include <services.h>
#include <propertyadapter.h>
// lib specific
#include "icon.h"


namespace Khalkhi {

Icon::Icon( int Size )
: Data( Size, Size, 32 ), Symbols( 0 )
{
    Data.fill( 0 );
    Data.setAlphaBuffer( true );

    SymbolSize = Size / 3;
    if( SymbolSize > 32 )
        SymbolSize = 32;
}

void Icon::appendIcon( const QImage &I )
{
    QImage Icon = I;

    if( Icon.size() != Data.size() )
        Icon = Icon.smoothScale( Data.size(), QImage::ScaleMin );

    int DX = (Data.width()-Icon.width()) / 2;
    int DY = (Data.height()-Icon.height()) / 2;

    bitBlt( &Data, DX, DY, &Icon, 0, 0, -1, -1 );
}

void Icon::appendSymbol( const QImage &S )
{
    ++Symbols;

    QImage Symbol = S;
    if( Symbol.size() != QSize(SymbolSize,SymbolSize) )
        Symbol = Symbol.smoothScale( SymbolSize, SymbolSize, QImage::ScaleMin );

    bitBlt( &Data, Data.width()-SymbolSize, Data.height()-Symbols*SymbolSize, &Symbol, 0, 0, -1, -1 );
}

void Icon::fill( const KABC::Addressee &Person )
{
    const PropertyManagerList &Managers = Services::self()->propertyManagers();

    PropertyManagerList::ConstIterator ManagerIt = Managers.begin();
    for( ; ManagerIt != Managers.end(); ++ManagerIt )
    {
        const PropertyAdapter *Adapter = (*ManagerIt)->propertyAdapter();
        const PropertyStatusServiceList &StatusServices = (*ManagerIt)->statusServices();

        // skip entries without status
        if( StatusServices.size() == 0 )
            continue;

        const int ItemSize = Adapter->numberOfItems( Person );
        for( int ItemIndex = 0; ItemIndex<ItemSize; ++ItemIndex )
        {
            // get status
            QString Status;
            PropertyStatusServiceList::ConstIterator StatusServicesIt = StatusServices.begin();
            for( ; StatusServicesIt != StatusServices.end(); ++StatusServicesIt )
            {
                if( (*StatusServicesIt)->supports(Person,ItemIndex) )
                {
                    QImage Symbol =
                        (*StatusServicesIt)->status( Person, ItemIndex, 0 ).data(DisplayIconRole).asImage();
                    if( !Symbol.isNull() )
                        appendSymbol( Symbol );
                }
            }
        }
    }
}

}
