/*
    This file is part of the KDE project.
    Copyright (c) 2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// Qt
#include <qtabwidget.h>
// KDE
#include <klocale.h>
// module
#include "presentationcontrol.h"
#include "personconfigdialog.h"


PersonConfigDialog::PersonConfigDialog( const QString &name, QWidget *parent )
 : KDialogBase( parent, 0, true, i18n("Configure Button for %1").arg(name), Ok|Cancel, Ok, true )
{
    // base 
    QTabWidget *tabs = new QTabWidget( this );
    tabs->setMargin( marginHint() );

    m_presentationControl = new PresentationControl( this );
    tabs->addTab( m_presentationControl, i18n("&Presentations") );
    connect( m_presentationControl, SIGNAL(changed(bool)),  SIGNAL(changed(bool)) );

    setMainWidget( tabs );
}


PersonConfigDialog::~PersonConfigDialog() {}

#include "personconfigdialog.moc"
