/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KIAXACCOUNT_H
#define KIAXACCOUNT_H

#include <qobject.h>
#include <qsettings.h>
#include <qptrvector.h>
#include <qstringlist.h>

#define ACCOUNT_INACTIVE 			0
#define ACCOUNT_CONNECTING		1
#define ACCOUNT_ACCEPTED		2
#define ACCOUNT_REJECTED			3
#define ACCOUNT_TIMEOUT			4


class KiaxAccount : public QObject
{
Q_OBJECT
public:
    KiaxAccount(QString name);

    ~KiaxAccount();
    bool save();
    bool load();
    void remove();
    void setState(int state);
    
public:
    QString accId;
    QString accAlias;
    QString accIcon;
    QString accountName;
    QString iaxServer;
    QString username;
    QString password;
    QString callerId;
    QString callerIdNumber;
    QString codec;
    bool registerAccount;
    int state;
    int iaxRegistrationId;  // this id is set by iaxc_register
    
    static int nextAcc;
    
private:
    QString accAliasKey;
    QString accName;
    QString accServer;
    QString accUsername;
    QString accPassword;
    QString accCallerId;
    QString accCallerIdNumber;
    QString accCodec;
    QString accRegisterAccount;

private:

    void setKeys(QSettings * settings);

signals:

    void signalRegistrationInactive(KiaxAccount* account);
    void signalRegistrationConnecting(KiaxAccount* account);
    void signalRegistrationAccepted(KiaxAccount* account);
    void signalRegistrationRejected(KiaxAccount* account);
    void signalRegistrationTimeout(KiaxAccount* account);

};

#endif
