/////////////////////////////////////////////////////////////////////////////

// Name:        dialog_build_BOM.cpp
// Purpose:
// Author:      jean-pierre Charras
// Modified by:
// Created:     01/15/06 18:18:44
// RCS-ID:
// Copyright:   GNU license
// Licence:
/////////////////////////////////////////////////////////////////////////////

// Generated by DialogBlocks (unregistered), 01/15/06 18:18:44

#if defined (__GNUG__) && !defined (__APPLE__)
#pragma implementation "dialog_build_BOM.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include "fctsys.h"

////@begin includes
////@end includes

#include "common.h"
#include "program.h"
#include "libcmp.h"
#include "general.h"
#include "netlist.h"

#include "dialog_build_BOM.h"


#include "protos.h"

////@begin XPM images
////@end XPM images


/* Local variables */
static bool  s_ListByRef   = TRUE;
static bool  s_ListByValue = TRUE;
static bool  s_ListWithSubCmponents;
static bool  s_ListHierarchicalPinByName;
static bool  s_ListBySheet;
static bool  s_BrowsList;
static int   s_OutputFormOpt;
static int   s_OutputSeparatorOpt;
static bool  s_Add_FpField_state;
static bool  s_Add_F1_state;
static bool  s_Add_F2_state;
static bool  s_Add_F3_state;
static bool  s_Add_F4_state;
static bool  s_Add_F5_state;
static bool  s_Add_F6_state;
static bool  s_Add_F7_state;
static bool  s_Add_F8_state;
static bool* s_AddFieldList[] = {
    &s_Add_FpField_state,
    &s_Add_F1_state,
    &s_Add_F2_state,
    &s_Add_F3_state,
    &s_Add_F4_state,
    &s_Add_F5_state,
    &s_Add_F6_state,
    &s_Add_F7_state,
    &s_Add_F8_state,
    NULL
};


#define OPTION_BOM_FORMAT    wxT( "BomFormat" )
#define OPTION_BOM_SEPARATOR wxT( "BomExportSeparator" )
#define OPTION_BOM_ADD_FIELD wxT( "BomAddField" )

/* list of separators used in bom export to spreadsheet
 * (selected by s_OutputSeparatorOpt, and s_OutputSeparatorOpt radiobox)
 */
static char s_ExportSeparator[] = ("\t;,.");

/*!
 * WinEDA_Build_BOM_Frame type definition
 */

IMPLEMENT_DYNAMIC_CLASS( WinEDA_Build_BOM_Frame, wxDialog )

/*!
 * WinEDA_Build_BOM_Frame event table definition
 */

BEGIN_EVENT_TABLE( WinEDA_Build_BOM_Frame, wxDialog )

////@begin WinEDA_Build_BOM_Frame event table entries
    EVT_RADIOBOX( ID_RADIOBOX_SELECT_FORMAT, WinEDA_Build_BOM_Frame::OnRadioboxSelectFormatSelected )

    EVT_BUTTON( ID_CREATE_LIST, WinEDA_Build_BOM_Frame::OnCreateListClick )

    EVT_BUTTON( wxID_OK, WinEDA_Build_BOM_Frame::OnOkClick )

    EVT_BUTTON( wxID_CANCEL, WinEDA_Build_BOM_Frame::OnCancelClick )

    EVT_BUTTON( wxID_APPLY, WinEDA_Build_BOM_Frame::OnApplyClick )

////@end WinEDA_Build_BOM_Frame event table entries

END_EVENT_TABLE()


/*!
 * WinEDA_Build_BOM_Frame constructors
 */

WinEDA_Build_BOM_Frame::WinEDA_Build_BOM_Frame()
{
}


WinEDA_Build_BOM_Frame::WinEDA_Build_BOM_Frame( WinEDA_DrawFrame* parent,
                                                wxWindowID        id,
                                                const wxString&   caption,
                                                const wxPoint&    pos,
                                                const wxSize&     size,
                                                long              style )
{
    m_Parent = parent;

    /* Get options */
    s_OutputFormOpt      = m_Parent->m_Parent->m_EDA_Config->Read( OPTION_BOM_FORMAT, (long) 0 );
    s_OutputSeparatorOpt = m_Parent->m_Parent->m_EDA_Config->Read( OPTION_BOM_SEPARATOR, (long) 0 );
    long addfields = m_Parent->m_Parent->m_EDA_Config->Read( OPTION_BOM_ADD_FIELD, (long) 0 );
    for( int ii = 0, bitmask = 1; s_AddFieldList[ii] != NULL; ii++ )
    {
        if( (addfields & bitmask) )
            *s_AddFieldList[ii] = true;
        else
            *s_AddFieldList[ii] = false;

        bitmask <<= 1;
    }

    Create( parent, id, caption, pos, size, style );

    m_OutputFormCtrl->SetSelection( s_OutputFormOpt );
    m_OutputSeparatorCtrl->SetSelection( s_OutputSeparatorOpt );

    // Enable/disable options:
    if( s_OutputFormOpt == 1 )
    {
        m_OutputSeparatorCtrl->Enable( true );
        m_ListCmpbyValItems->Enable( false );
        m_GenListLabelsbyVal->Enable( false );
        m_GenListLabelsbySheet->Enable( false );
    }
    else
    {
        m_OutputSeparatorCtrl->Enable( false );
        m_ListCmpbyValItems->Enable( true );
        m_GenListLabelsbyVal->Enable( true );
        m_GenListLabelsbySheet->Enable( true );
    }
}


/*!
 * WinEDA_Build_BOM_Frame creator
 */

bool WinEDA_Build_BOM_Frame::Create( wxWindow*       parent,
                                     wxWindowID      id,
                                     const wxString& caption,
                                     const wxPoint&  pos,
                                     const wxSize&   size,
                                     long            style )
{
////@begin WinEDA_Build_BOM_Frame member initialisation
    m_ListCmpbyRefItems = NULL;
    m_ListSubCmpItems = NULL;
    m_ListCmpbyValItems = NULL;
    m_GenListLabelsbyVal = NULL;
    m_GenListLabelsbySheet = NULL;
    m_OutputFormCtrl = NULL;
    m_OutputSeparatorCtrl = NULL;
    m_GetListBrowser = NULL;
    m_FieldsToAppendListSizer = NULL;
    m_AddFootprintField = NULL;
    m_AddField1 = NULL;
    m_AddField2 = NULL;
    m_AddField3 = NULL;
    m_AddField4 = NULL;
    m_AddField5 = NULL;
    m_AddField6 = NULL;
    m_AddField7 = NULL;
    m_AddField8 = NULL;
    m_btClose = NULL;
////@end WinEDA_Build_BOM_Frame member initialisation

////@begin WinEDA_Build_BOM_Frame creation
    SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if (GetSizer())
    {
        GetSizer()->SetSizeHints(this);
    }
    Centre();
////@end WinEDA_Build_BOM_Frame creation
    return TRUE;
}


/*!
 * Control creation for WinEDA_Build_BOM_Frame
 */

void WinEDA_Build_BOM_Frame::CreateControls()
{
    SetFont( *g_DialogFont );

////@begin WinEDA_Build_BOM_Frame content construction
    // Generated by DialogBlocks, 29/04/2008 20:58:26 (unregistered)

    WinEDA_Build_BOM_Frame* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer2->Add(itemBoxSizer3, 0, wxALIGN_CENTER_HORIZONTAL|wxLEFT|wxRIGHT, 5);

    wxBoxSizer* itemBoxSizer4 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer3->Add(itemBoxSizer4, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM, 5);

    wxStaticBox* itemStaticBoxSizer5Static = new wxStaticBox(itemDialog1, wxID_ANY, _("List items:"));
    wxStaticBoxSizer* itemStaticBoxSizer5 = new wxStaticBoxSizer(itemStaticBoxSizer5Static, wxVERTICAL);
    itemBoxSizer4->Add(itemStaticBoxSizer5, 0, wxGROW|wxALL, 5);

    m_ListCmpbyRefItems = new wxCheckBox( itemDialog1, ID_CHECKBOX1, _("Components by Reference"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_ListCmpbyRefItems->SetValue(true);
    itemStaticBoxSizer5->Add(m_ListCmpbyRefItems, 0, wxALIGN_LEFT|wxALL, 5);

    m_ListSubCmpItems = new wxCheckBox( itemDialog1, ID_CHECKBOX2, _("Sub Components (i.e. U2A, U2B ...)"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_ListSubCmpItems->SetValue(false);
    itemStaticBoxSizer5->Add(m_ListSubCmpItems, 0, wxALIGN_LEFT|wxALL, 5);

    m_ListCmpbyValItems = new wxCheckBox( itemDialog1, ID_CHECKBOX3, _("Components by Value"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_ListCmpbyValItems->SetValue(true);
    itemStaticBoxSizer5->Add(m_ListCmpbyValItems, 0, wxALIGN_LEFT|wxALL, 5);

    m_GenListLabelsbyVal = new wxCheckBox( itemDialog1, ID_CHECKBOX4, _("Hierachy Pins by Name"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_GenListLabelsbyVal->SetValue(false);
    itemStaticBoxSizer5->Add(m_GenListLabelsbyVal, 0, wxALIGN_LEFT|wxALL, 5);

    m_GenListLabelsbySheet = new wxCheckBox( itemDialog1, ID_CHECKBOX5, _("Hierachy Pins by Sheets"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_GenListLabelsbySheet->SetValue(false);
    itemStaticBoxSizer5->Add(m_GenListLabelsbySheet, 0, wxALIGN_LEFT|wxALL, 5);

    wxArrayString m_OutputFormCtrlStrings;
    m_OutputFormCtrlStrings.Add(_("List"));
    m_OutputFormCtrlStrings.Add(_("Text for spreadsheet import"));
    m_OutputFormCtrl = new wxRadioBox( itemDialog1, ID_RADIOBOX_SELECT_FORMAT, _("Output format:"), wxDefaultPosition, wxDefaultSize, m_OutputFormCtrlStrings, 1, wxRA_SPECIFY_COLS );
    m_OutputFormCtrl->SetSelection(0);
    itemBoxSizer4->Add(m_OutputFormCtrl, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP, 5);

    wxArrayString m_OutputSeparatorCtrlStrings;
    m_OutputSeparatorCtrlStrings.Add(_("Tab"));
    m_OutputSeparatorCtrlStrings.Add(_(";"));
    m_OutputSeparatorCtrlStrings.Add(_(","));
    m_OutputSeparatorCtrl = new wxRadioBox( itemDialog1, ID_RADIOBOX_SEPARATOR, _("Field separator for spreadsheet import:"), wxDefaultPosition, wxDefaultSize, m_OutputSeparatorCtrlStrings, 1, wxRA_SPECIFY_ROWS );
    m_OutputSeparatorCtrl->SetSelection(0);
    itemBoxSizer4->Add(m_OutputSeparatorCtrl, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticBox* itemStaticBoxSizer13Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Options:"));
    wxStaticBoxSizer* itemStaticBoxSizer13 = new wxStaticBoxSizer(itemStaticBoxSizer13Static, wxHORIZONTAL);
    itemBoxSizer4->Add(itemStaticBoxSizer13, 0, wxGROW|wxALL, 5);

    m_GetListBrowser = new wxCheckBox( itemDialog1, ID_CHECKBOX6, _("Launch list browser"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_GetListBrowser->SetValue(false);
    itemStaticBoxSizer13->Add(m_GetListBrowser, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxBoxSizer* itemBoxSizer15 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer3->Add(itemBoxSizer15, 0, wxALIGN_TOP|wxLEFT|wxTOP|wxBOTTOM, 5);

    wxStaticBox* itemStaticBoxSizer16Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Fields to add:"));
    m_FieldsToAppendListSizer = new wxStaticBoxSizer(itemStaticBoxSizer16Static, wxVERTICAL);
    itemBoxSizer15->Add(m_FieldsToAppendListSizer, 0, wxALIGN_LEFT|wxALL, 5);

    m_AddFootprintField = new wxCheckBox( itemDialog1, ID_CHECKBOX_FOOTPRINT_FIELD, _("Footprint"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_AddFootprintField->SetValue(false);
    m_FieldsToAppendListSizer->Add(m_AddFootprintField, 0, wxGROW|wxALL, 5);

    m_AddField1 = new wxCheckBox( itemDialog1, ID_CHECKBOX_FIELD1, _("Field 1"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_AddField1->SetValue(false);
    m_FieldsToAppendListSizer->Add(m_AddField1, 0, wxGROW|wxALL, 5);

    m_AddField2 = new wxCheckBox( itemDialog1, ID_CHECKBOX_FIELD2, _("Field 2"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_AddField2->SetValue(false);
    m_FieldsToAppendListSizer->Add(m_AddField2, 0, wxGROW|wxALL, 5);

    m_AddField3 = new wxCheckBox( itemDialog1, ID_CHECKBOX_FIELD3, _("Field 3"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_AddField3->SetValue(false);
    m_FieldsToAppendListSizer->Add(m_AddField3, 0, wxGROW|wxALL, 5);

    m_AddField4 = new wxCheckBox( itemDialog1, ID_CHECKBOX_FIELD4, _("Field 4"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_AddField4->SetValue(false);
    m_FieldsToAppendListSizer->Add(m_AddField4, 0, wxGROW|wxALL, 5);

    m_AddField5 = new wxCheckBox( itemDialog1, ID_CHECKBOX_FIELD5, _("Field 5"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_AddField5->SetValue(false);
    m_FieldsToAppendListSizer->Add(m_AddField5, 0, wxGROW|wxALL, 5);

    m_AddField6 = new wxCheckBox( itemDialog1, ID_CHECKBOX_FIELD6, _("Field 6"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_AddField6->SetValue(false);
    m_FieldsToAppendListSizer->Add(m_AddField6, 0, wxGROW|wxALL, 5);

    m_AddField7 = new wxCheckBox( itemDialog1, ID_CHECKBOX_FIELD7, _("Field 7"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_AddField7->SetValue(false);
    m_FieldsToAppendListSizer->Add(m_AddField7, 0, wxGROW|wxALL, 5);

    m_AddField8 = new wxCheckBox( itemDialog1, ID_CHECKBOX_FIELD8, _("Field 8"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_AddField8->SetValue(false);
    m_FieldsToAppendListSizer->Add(m_AddField8, 0, wxGROW|wxALL, 5);

    itemBoxSizer15->Add(5, 5, 0, wxGROW|wxALL, 10);

    wxButton* itemButton27 = new wxButton( itemDialog1, ID_CREATE_LIST, _("Create &List"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton27->SetDefault();
    itemButton27->SetForegroundColour(wxColour(166, 0, 0));
    itemBoxSizer15->Add(itemButton27, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    wxBoxSizer* itemBoxSizer28 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer2->Add(itemBoxSizer28, 0, wxALIGN_CENTER_HORIZONTAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxButton* itemButton29 = new wxButton( itemDialog1, wxID_OK, _("&OK"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton29->SetForegroundColour(wxColour(255, 0, 0));
    itemBoxSizer28->Add(itemButton29, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    m_btClose = new wxButton( itemDialog1, wxID_CANCEL, _("&Close"), wxDefaultPosition, wxDefaultSize, 0 );
    m_btClose->SetForegroundColour(wxColour(0, 0, 255));
    itemBoxSizer28->Add(m_btClose, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxButton* itemButton31 = new wxButton( itemDialog1, wxID_APPLY, _("&Apply"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer28->Add(itemButton31, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    // Set validators
    m_ListCmpbyRefItems->SetValidator( wxGenericValidator(& s_ListByRef) );
    m_ListSubCmpItems->SetValidator( wxGenericValidator(& s_ListWithSubCmponents) );
    m_ListCmpbyValItems->SetValidator( wxGenericValidator(& s_ListByValue) );
    m_GenListLabelsbyVal->SetValidator( wxGenericValidator(& s_ListHierarchicalPinByName) );
    m_GenListLabelsbySheet->SetValidator( wxGenericValidator(& s_ListBySheet) );
    m_OutputFormCtrl->SetValidator( wxGenericValidator(& s_OutputFormOpt) );
    m_OutputSeparatorCtrl->SetValidator( wxGenericValidator(& s_OutputSeparatorOpt) );
    m_GetListBrowser->SetValidator( wxGenericValidator(& s_BrowsList) );
    m_AddFootprintField->SetValidator( wxGenericValidator(& s_Add_FpField_state) );
    m_AddField1->SetValidator( wxGenericValidator(& s_Add_F1_state) );
    m_AddField2->SetValidator( wxGenericValidator(& s_Add_F2_state) );
    m_AddField3->SetValidator( wxGenericValidator(& s_Add_F3_state) );
    m_AddField4->SetValidator( wxGenericValidator(& s_Add_F4_state) );
    m_AddField5->SetValidator( wxGenericValidator(& s_Add_F5_state) );
    m_AddField6->SetValidator( wxGenericValidator(& s_Add_F6_state) );
    m_AddField7->SetValidator( wxGenericValidator(& s_Add_F7_state) );
    m_AddField8->SetValidator( wxGenericValidator(& s_Add_F8_state) );
////@end WinEDA_Build_BOM_Frame content construction

    m_btClose->SetFocus();
}


/*!
 * Should we show tooltips?
 */

bool WinEDA_Build_BOM_Frame::ShowToolTips()
{
    return TRUE;
}


/*!
 * Get bitmap resources
 */

wxBitmap WinEDA_Build_BOM_Frame::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin WinEDA_Build_BOM_Frame bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end WinEDA_Build_BOM_Frame bitmap retrieval
}


/*!
 * Get icon resources
 */

wxIcon WinEDA_Build_BOM_Frame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin WinEDA_Build_BOM_Frame icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end WinEDA_Build_BOM_Frame icon retrieval
}


/*!
 * wxEVT_COMMAND_RADIOBOX_SELECTED event handler for ID_RADIOBOX_SELECT_FORMAT
 */

void WinEDA_Build_BOM_Frame::OnRadioboxSelectFormatSelected( wxCommandEvent& event )
{
    if( m_OutputFormCtrl->GetSelection() == 1 )
    {
        m_OutputSeparatorCtrl->Enable( true );
        m_ListCmpbyValItems->Enable( false );
        m_GenListLabelsbyVal->Enable( false );
        m_GenListLabelsbySheet->Enable( false );
    }
    else
    {
        m_OutputSeparatorCtrl->Enable( false );
        m_ListCmpbyValItems->Enable( true );
        m_GenListLabelsbyVal->Enable( true );
        m_GenListLabelsbySheet->Enable( true );
    }
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_CREATE_LIST
 */

void WinEDA_Build_BOM_Frame::OnCreateListClick( wxCommandEvent& event )
{
    char ExportSeparatorSymbol = s_ExportSeparator[0];
    if( m_OutputSeparatorCtrl->GetSelection() > 0 )
        ExportSeparatorSymbol = s_ExportSeparator[m_OutputSeparatorCtrl->GetSelection()];

    bool ExportFileType = m_OutputFormCtrl->GetSelection() == 0 ? false : true;

    SavePreferences();

    Create_BOM_Lists( ExportFileType, m_ListSubCmpItems->GetValue(),
                      ExportSeparatorSymbol, m_GetListBrowser->GetValue());
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
 */

void WinEDA_Build_BOM_Frame::OnOkClick( wxCommandEvent& event )
{
    SavePreferences();
    EndModal( 0 );
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
 */

void WinEDA_Build_BOM_Frame::OnCancelClick( wxCommandEvent& event )
{
    EndModal( -1 );
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_APPLY
 */

void WinEDA_Build_BOM_Frame::OnApplyClick( wxCommandEvent& event )
{
    SavePreferences();
}


/**************************************************/
void WinEDA_Build_BOM_Frame::SavePreferences()
/**************************************************/
{
    // Determine current settings of "List items" and "Options" checkboxes
    // (NOTE: These 6 settings are restored when the dialog box is next
    // invoked, but are *not* still saved after EESchema is next shut down.)
    s_ListByRef = m_ListCmpbyRefItems->GetValue();
    s_ListWithSubCmponents = m_ListSubCmpItems->GetValue();
    s_ListByValue = m_ListCmpbyValItems->GetValue();
    s_ListHierarchicalPinByName = m_GenListLabelsbyVal->GetValue();
    s_ListBySheet = m_GenListLabelsbySheet->GetValue();
    s_BrowsList   = m_GetListBrowser->GetValue();

    // Determine current settings of both radiobutton groups
    s_OutputFormOpt      = m_OutputFormCtrl->GetSelection();
    s_OutputSeparatorOpt = m_OutputSeparatorCtrl->GetSelection();
    if( s_OutputSeparatorOpt < 0 )
        s_OutputSeparatorOpt = 0;

    // Determine current settings of all "Fields to add" checkboxes
    s_Add_FpField_state = m_AddFootprintField->GetValue();
    s_Add_F1_state = m_AddField1->GetValue();
    s_Add_F2_state = m_AddField2->GetValue();
    s_Add_F3_state = m_AddField3->GetValue();
    s_Add_F4_state = m_AddField4->GetValue();
    s_Add_F5_state = m_AddField5->GetValue();
    s_Add_F6_state = m_AddField6->GetValue();
    s_Add_F7_state = m_AddField7->GetValue();
    s_Add_F8_state = m_AddField8->GetValue();

    // Now save current settings of both radiobutton groups
    m_Parent->m_Parent->m_EDA_Config->Write( OPTION_BOM_FORMAT, (long) s_OutputFormOpt );
    m_Parent->m_Parent->m_EDA_Config->Write( OPTION_BOM_SEPARATOR, (long) s_OutputSeparatorOpt );

    // Now save current settings of all "Fields to add" checkboxes
    long addfields = 0;
    for( int ii = 0, bitmask = 1; s_AddFieldList[ii] != NULL; ii++ )
    {
        if( *s_AddFieldList[ii] )
            addfields |= bitmask;
        bitmask <<= 1;
    }

    m_Parent->m_Parent->m_EDA_Config->Write( OPTION_BOM_ADD_FIELD, addfields );
}
