/////////////////////////////////////////////////////////////////////////////

// Name:        dialog_netlist.cpp
// Purpose:
// Author:      jean-pierre Charras
// Modified by:
// Created:     26/02/2006 17:42:19
// RCS-ID:
// Copyright:   License GNU
// Licence:
/////////////////////////////////////////////////////////////////////////////

// Generated by DialogBlocks (unregistered), 26/02/2006 17:42:19

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "dialog_netlist.h"

////@begin XPM images
////@end XPM images

static bool DisplayWarning;

/*!
 * WinEDA_NetlistFrame type definition
 */

IMPLEMENT_DYNAMIC_CLASS( WinEDA_NetlistFrame, wxDialog )

/*!
 * WinEDA_NetlistFrame event table definition
 */

BEGIN_EVENT_TABLE( WinEDA_NetlistFrame, wxDialog )

////@begin WinEDA_NetlistFrame event table entries
    EVT_BUTTON( ID_OPEN_NELIST, WinEDA_NetlistFrame::OnOpenNelistClick )

    EVT_BUTTON( ID_READ_NETLIST_FILE, WinEDA_NetlistFrame::OnReadNetlistFileClick )

    EVT_BUTTON( ID_TEST_NETLIST, WinEDA_NetlistFrame::OnTestNetlistClick )

    EVT_BUTTON( ID_COMPILE_RATSNEST, WinEDA_NetlistFrame::OnCompileRatsnestClick )

    EVT_BUTTON( wxID_CANCEL, WinEDA_NetlistFrame::OnCancelClick )

////@end WinEDA_NetlistFrame event table entries

END_EVENT_TABLE()

/*!
 * WinEDA_NetlistFrame constructors
 */

WinEDA_NetlistFrame::WinEDA_NetlistFrame()
{
}


WinEDA_NetlistFrame::WinEDA_NetlistFrame( WinEDA_PcbFrame* parent,
                                          wxDC* DC,
                                          const wxString& aNetlistFilename,
                                          wxWindowID id,
                                          const wxString& caption,
                                          const wxPoint& pos,
                                          const wxSize& size,
                                          long style )
{
    m_Parent = parent;
    m_DC = DC;

    Create( parent, id, caption, pos, size, style );

    m_NetlistFilenameCtrl->SetValue( aNetlistFilename );
}


/*!
 * WinEDA_NetlistFrame destructor
 */

WinEDA_NetlistFrame::~WinEDA_NetlistFrame()
{
}

/*!
 * WinEDA_NetlistFrame creator
 */

bool WinEDA_NetlistFrame::Create( wxWindow* parent,
                                  wxWindowID id,
                                  const wxString& caption,
                                  const wxPoint& pos,
                                  const wxSize& size,
                                  long style )
{
////@begin WinEDA_NetlistFrame member initialisation
    m_Select_By_Timestamp = NULL;
    m_ChangeExistingFootprintCtrl = NULL;
    m_DeleteBadTracks = NULL;
    m_DisplayWarningCtrl = NULL;
    m_RemoveExtraFootprintsCtrl = NULL;
    m_btClose = NULL;
    m_NetlistFilenameCtrl = NULL;
    m_MessageWindow = NULL;
    StdDialogButtonSizer = NULL;
////@end WinEDA_NetlistFrame member initialisation

////@begin WinEDA_NetlistFrame creation
    SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if (GetSizer())
    {
        GetSizer()->SetSizeHints(this);
    }
    Centre();
////@end WinEDA_NetlistFrame creation
    return true;
}


/*!
 * Control creation for WinEDA_NetlistFrame
 */

void WinEDA_NetlistFrame::CreateControls()
{
    SetFont( *g_DialogFont );

////@begin WinEDA_NetlistFrame content construction
    // Generated by DialogBlocks, 29/04/2008 20:56:53 (unregistered)

    WinEDA_NetlistFrame* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer2->Add(itemBoxSizer3, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP, 5);

    wxBoxSizer* itemBoxSizer4 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer3->Add(itemBoxSizer4, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM, 5);

    wxBoxSizer* itemBoxSizer5 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer4->Add(itemBoxSizer5, 0, wxGROW|wxALL, 5);

    wxArrayString m_Select_By_TimestampStrings;
    m_Select_By_TimestampStrings.Add(_("Reference"));
    m_Select_By_TimestampStrings.Add(_("Timestamp"));
    m_Select_By_Timestamp = new wxRadioBox( itemDialog1, ID_SELECTION_FOOTPRINT_MODE, _("Module Selection:"), wxDefaultPosition, wxDefaultSize, m_Select_By_TimestampStrings, 1, wxRA_SPECIFY_COLS );
    m_Select_By_Timestamp->SetSelection(0);
    if (WinEDA_NetlistFrame::ShowToolTips())
        m_Select_By_Timestamp->SetToolTip(_("Select how footprints are reconized:\nby their reference (U1, R3...) (normal setting)\nor their time stamp (special setting after a full schematic reannotation)"));
    itemBoxSizer5->Add(m_Select_By_Timestamp, 0, wxGROW|wxALL, 5);

    wxArrayString m_ChangeExistingFootprintCtrlStrings;
    m_ChangeExistingFootprintCtrlStrings.Add(_("Keep"));
    m_ChangeExistingFootprintCtrlStrings.Add(_("Change"));
    m_ChangeExistingFootprintCtrl = new wxRadioBox( itemDialog1, ID_KEEP_OR_CHANGE_FOOTPRINTS, _("Exchange Module:"), wxDefaultPosition, wxDefaultSize, m_ChangeExistingFootprintCtrlStrings, 1, wxRA_SPECIFY_COLS );
    m_ChangeExistingFootprintCtrl->SetSelection(0);
    if (WinEDA_NetlistFrame::ShowToolTips())
        m_ChangeExistingFootprintCtrl->SetToolTip(_("Keep or change an existing footprint when the netlist gives a different footprint"));
    itemBoxSizer5->Add(m_ChangeExistingFootprintCtrl, 0, wxGROW|wxALL, 5);

    itemBoxSizer4->Add(5, 5, 1, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxBoxSizer* itemBoxSizer9 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer4->Add(itemBoxSizer9, 0, wxGROW|wxALL, 5);

    wxArrayString m_DeleteBadTracksStrings;
    m_DeleteBadTracksStrings.Add(_("Keep"));
    m_DeleteBadTracksStrings.Add(_("Delete"));
    m_DeleteBadTracks = new wxRadioBox( itemDialog1, ID_DELETE_TRACKS_OPTION, _("Bad Tracks Deletion:"), wxDefaultPosition, wxDefaultSize, m_DeleteBadTracksStrings, 1, wxRA_SPECIFY_COLS );
    m_DeleteBadTracks->SetSelection(0);
    if (WinEDA_NetlistFrame::ShowToolTips())
        m_DeleteBadTracks->SetToolTip(_("Keep or delete bad tracks after a netlist change"));
    itemBoxSizer9->Add(m_DeleteBadTracks, 0, wxGROW|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer11Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Options"));
    wxStaticBoxSizer* itemStaticBoxSizer11 = new wxStaticBoxSizer(itemStaticBoxSizer11Static, wxVERTICAL);
    itemBoxSizer9->Add(itemStaticBoxSizer11, 0, wxGROW|wxALL, 5);

    m_DisplayWarningCtrl = new wxCheckBox( itemDialog1, ID_DISPLAY_WARNINGS_OPT, _("Display Warnings"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_DisplayWarningCtrl->SetValue(false);
    itemStaticBoxSizer11->Add(m_DisplayWarningCtrl, 0, wxGROW|wxALL, 5);

    m_RemoveExtraFootprintsCtrl = new wxCheckBox( itemDialog1, ID_REMOVE_EXTRA_FOOTPRINTS_OPT, _("Remove Extra Footprints"), wxDefaultPosition, wxDefaultSize, 0 );
    m_RemoveExtraFootprintsCtrl->SetValue(false);
    if (WinEDA_NetlistFrame::ShowToolTips())
        m_RemoveExtraFootprintsCtrl->SetToolTip(_("Remove footprints found on the Board but not in netlist\nNote: only not locked footprints will be removed"));
    itemStaticBoxSizer11->Add(m_RemoveExtraFootprintsCtrl, 0, wxGROW|wxALL, 5);

    itemBoxSizer3->Add(5, 5, 1, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxBoxSizer* itemBoxSizer15 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer3->Add(itemBoxSizer15, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM, 5);

    wxButton* itemButton16 = new wxButton( itemDialog1, ID_OPEN_NELIST, _("Browse Netlist Files"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton16->SetForegroundColour(wxColour(217, 0, 0));
    itemBoxSizer15->Add(itemButton16, 0, wxGROW|wxALL, 5);

    wxButton* itemButton17 = new wxButton( itemDialog1, ID_READ_NETLIST_FILE, _("Read Current Netlist"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton17->SetForegroundColour(wxColour(0, 128, 0));
    itemBoxSizer15->Add(itemButton17, 0, wxGROW|wxALL, 5);

    wxButton* itemButton18 = new wxButton( itemDialog1, ID_TEST_NETLIST, _("Footprints Test"), wxDefaultPosition, wxDefaultSize, 0 );
    if (WinEDA_NetlistFrame::ShowToolTips())
        itemButton18->SetToolTip(_("Read the current neltist file and list missing and extra footprints"));
    itemButton18->SetForegroundColour(wxColour(0, 128, 128));
    itemBoxSizer15->Add(itemButton18, 0, wxGROW|wxALL, 5);

    wxButton* itemButton19 = new wxButton( itemDialog1, ID_COMPILE_RATSNEST, _("Rebuild Board Connectivity"), wxDefaultPosition, wxDefaultSize, 0 );
    if (WinEDA_NetlistFrame::ShowToolTips())
        itemButton19->SetToolTip(_("Rebuild the full ratsnest (usefull after a manual pad netname edition)"));
    itemButton19->SetForegroundColour(wxColour(0, 0, 132));
    itemBoxSizer15->Add(itemButton19, 0, wxGROW|wxALL, 5);

    m_btClose = new wxButton( itemDialog1, wxID_CANCEL, _("Close"), wxDefaultPosition, wxDefaultSize, 0 );
    m_btClose->SetDefault();
    itemBoxSizer15->Add(m_btClose, 0, wxGROW|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer21Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Netlist File:"));
    wxStaticBoxSizer* itemStaticBoxSizer21 = new wxStaticBoxSizer(itemStaticBoxSizer21Static, wxVERTICAL);
    itemStaticBoxSizer21Static->SetForegroundColour(wxColour(0, 0, 255));
    itemBoxSizer2->Add(itemStaticBoxSizer21, 0, wxGROW|wxALL, 5);

    m_NetlistFilenameCtrl = new wxTextCtrl( itemDialog1, ID_TEXT_NETLIST_FILENAME, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticBoxSizer21->Add(m_NetlistFilenameCtrl, 0, wxGROW|wxALL, 5);

    m_MessageWindow = new wxTextCtrl( itemDialog1, ID_TEXTCTRL, _T(""), wxDefaultPosition, wxSize(-1, 120), wxTE_MULTILINE|wxTE_READONLY );
    itemBoxSizer2->Add(m_MessageWindow, 1, wxGROW|wxALL, 10);

    wxStaticLine* itemStaticLine24 = new wxStaticLine( itemDialog1, ID_STATICLINE, wxDefaultPosition, wxDefaultSize, wxLI_HORIZONTAL );
    itemBoxSizer2->Add(itemStaticLine24, 0, wxGROW|wxLEFT|wxRIGHT, 5);

    StdDialogButtonSizer = new wxStdDialogButtonSizer;

    itemBoxSizer2->Add(StdDialogButtonSizer, 0, wxGROW|wxALL, 10);
    wxButton* itemButton26 = new wxButton( itemDialog1, wxID_CANCEL, _("&Close"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton26->SetForegroundColour(wxColour(0, 0, 255));
    StdDialogButtonSizer->AddButton(itemButton26);

    StdDialogButtonSizer->Realize();

    // Set validators
    m_DisplayWarningCtrl->SetValidator( wxGenericValidator(& DisplayWarning) );
////@end WinEDA_NetlistFrame content construction

    m_btClose->SetFocus();
}


/*!
 * Should we show tooltips?
 */

bool WinEDA_NetlistFrame::ShowToolTips()
{
    return true;
}


/*!
 * Get bitmap resources
 */

wxBitmap WinEDA_NetlistFrame::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin WinEDA_NetlistFrame bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end WinEDA_NetlistFrame bitmap retrieval
}


/*!
 * Get icon resources
 */

wxIcon WinEDA_NetlistFrame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin WinEDA_NetlistFrame icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end WinEDA_NetlistFrame icon retrieval
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_OPEN_NELIST
 */

void WinEDA_NetlistFrame::OnOpenNelistClick( wxCommandEvent& event )
{
    wxString fullfilename, mask( wxT( "*" ) );

    fullfilename = m_NetlistFilenameCtrl->GetValue();
    mask += NetExtBuffer;

    fullfilename = EDA_FileSelector( _( "Netlist Selection:" ),
        wxEmptyString,                                  /* Chemin par defaut */
        fullfilename,                                   /* nom fichier par defaut */
        NetExtBuffer,                                   /* extension par defaut */
        mask,                                           /* Masque d'affichage */
        this,
        0,
        TRUE
        );

    if( fullfilename.IsEmpty() )
        return;
    m_NetlistFilenameCtrl->SetValue( fullfilename );
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_READ_NETLIST_FILE
 */

void WinEDA_NetlistFrame::OnReadNetlistFileClick( wxCommandEvent& event )
{
    wxString CmpFullFileName;
    CmpFullFileName = m_NetlistFilenameCtrl->GetValue();
    ChangeFileNameExt( CmpFullFileName, NetCmpExtBuffer );

    ReadPcbNetlist( m_Parent, m_NetlistFilenameCtrl->GetValue(),
                    CmpFullFileName,
                    m_MessageWindow,
                    m_ChangeExistingFootprintCtrl->GetSelection() == 1 ? TRUE : FALSE,
                    m_DeleteBadTracks->GetSelection() == 1 ? TRUE : FALSE,
                    m_RemoveExtraFootprintsCtrl->IsChecked(),
                    m_Select_By_Timestamp->GetSelection() == 1 ? TRUE : FALSE,
                    m_DisplayWarningCtrl->IsChecked());
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_TEST_NETLIST
 */

void WinEDA_NetlistFrame::OnTestNetlistClick( wxCommandEvent& event )
{
    TestFor_Duplicate_Missing_And_Extra_Footprints( this, m_NetlistFilenameCtrl->GetValue(), m_Parent->m_Pcb);
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_COMPILE_RATSNEST
 */

void WinEDA_NetlistFrame::OnCompileRatsnestClick( wxCommandEvent& event )
{
    m_Parent->Compile_Ratsnest( m_DC, TRUE );
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
 */

void WinEDA_NetlistFrame::OnCancelClick( wxCommandEvent& event )
{
    EndModal( -1 );
}
