#ifndef __dialog_schematic_find__
#define __dialog_schematic_find__

/**
 * @file
 *
 * Subclass of DIALOG_SCH_FIND_BASE, which is generated by wxFormBuilder.
 *
 * This dialog is used to define the search criteria used to search for items
 * in the current schematic.  What is searched depends on the schematic item
 * type.  Check the Matches() method for each item derived from SCH_ITEM() to
 * find out how matching is performed against that item.
 */

#include "dialog_schematic_find_base.h"

#include <wx/fdrepdlg.h>          // Use the wxFindReplaceDialog events, data, and enums.


/* Define schematic specific find and replace dialog flags based on the enum entries
 * in wxFindReplaceFlags.   These flags are intended to be used as bit masks in the
 * wxFindReplaceData::m_Flags member variable.  The varialble is defined as a wxUint32.
 */
enum SchematicFindReplaceFlags
{
    /* The last wxFindReplaceFlag enum is wxFR_MATCHCASE. */

    /* Search the current sheet only. */
    FR_CURRENT_SHEET_ONLY    = wxFR_MATCHCASE << 1,

    /* Search all fields in component, not just the value and reference fields. */
    FR_SEARCH_ALL_FIELDS     = wxFR_MATCHCASE << 2,

    /* Perform search using simple wild card matching (* & ?). */
    FR_MATCH_WILDCARD        = wxFR_MATCHCASE << 3,

    /* Wrap around the beginning or end of search list. */
    FR_SEARCH_WRAP           = wxFR_MATCHCASE << 4
};


/** Implementing DIALOG_SCH_FIND_BASE */
class DIALOG_SCH_FIND : public DIALOG_SCH_FIND_BASE
{
protected:
    // Handlers for DIALOG_SCH_FIND_BASE events.
    void OnClose( wxCloseEvent& aEvent );
    void OnUpdateFindUI( wxUpdateUIEvent& aEvent );
    void OnUpdateWholeWordUI( wxUpdateUIEvent& aEvent );
    void OnUpdateWildcardUI( wxUpdateUIEvent& aEvent );
    void OnFind( wxCommandEvent& aEvent );
    void OnCancel( wxCommandEvent& aEvent );

    void SendEvent( const wxEventType& aEventType );

    wxFindReplaceData *m_findReplaceData;

    DECLARE_NO_COPY_CLASS( DIALOG_SCH_FIND )

public:
    DIALOG_SCH_FIND( wxWindow* aParent, wxFindReplaceData* aData,
                     const wxPoint& aPosition = wxDefaultPosition,
                     const wxSize& aSize = wxDefaultSize, int aStyle = 0 );

    const wxFindReplaceData *GetData() const { return m_findReplaceData; }
    void SetData(wxFindReplaceData *aData) { m_findReplaceData = aData; }

    void SetFindEntries( const wxArrayString& aEntries );
    wxArrayString GetFindEntries() const;

    void SetReplaceEntries( const wxArrayString& aEntries );
    wxArrayString GetReplaceEntries() const { return m_comboReplace->GetStrings(); }
};


BEGIN_DECLARE_EVENT_TYPES()
    DECLARE_LOCAL_EVENT_TYPE( EVT_COMMAND_FIND_DRC_MARKER, wxID_ANY )
    DECLARE_LOCAL_EVENT_TYPE( EVT_COMMAND_FIND_COMPONENT_IN_LIB, wxID_ANY )
END_DECLARE_EVENT_TYPES()


#define EVT_FIND_DRC_MARKER( id, fn ) \
    wx__DECLARE_EVT1( EVT_COMMAND_FIND_DRC_MARKER, id, wxFindDialogEventHandler( fn ) )

#define EVT_FIND_COMPONENT_IN_LIB( id, fn ) \
    wx__DECLARE_EVT1( EVT_COMMAND_FIND_COMPONENT_IN_LIB, id, wxFindDialogEventHandler( fn ) )

#endif // __dialog_schematic_find__
