/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/
/*
  author: Niall Kavanagh <kavanagh@missioncriticallinux.com>
  description: Web-based cluster monitor utility.
 */

#define HEX_ESCAPE '%'
#define PSWITCH_STATUS_STRLEN 32

static const char *version __attribute__ ((unused)) = "$Revision";

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>


#include <sys/param.h>
#include <clusterdefs.h>
#include <clucfg.h>
#include <msgsvc.h>
#include <svcmgr.h>
#include <parseconf.h>
#include <diskapis.h>
#include <disk_proto.h>

#define BABEL_CLUSTER_NAME "cluster%name"

int listen_fd=-1;

int main (void) {

   char *defval, *value; /*, *key; */
   int rc, n, s, c;
   CluCfg *cfg;
   ServiceBlock svc;
   char *ptrR;
   
   time_t time_now;
   char *current_time;
   
   ChanState *chan_state;
   char **pswitch_str=NULL;
   generic_msg_hdr msghdr;
   msg_handle_t con;
   PswitchStatusMsg pswitch_msg;
   int auth=0;
   char image_name[128];
   
   defval = "Can't read value!";
   
   cfg = get_clu_cfg(NULL);
   if (cfg == NULL) {
      printf("Cannot continue: Can't read the cluster config!<br>\n");
      exit(1);
   }
   
   
   time_now = time(NULL);
   current_time = ctime(&time_now);
   
   
   
   msghdr.magic = GENERIC_HDR_MAGIC;
   
   pswitch_str = (char **)malloc(sizeof(char*) * cfg->num_nodes);
   for (n = 0; n < cfg->num_nodes; n++) {
      pswitch_str[n] = (char *)malloc(PSWITCH_STATUS_STRLEN);
   }
   
   chan_state = cluGetChanState();
   
   for (n = 0; n < cfg->num_nodes; n++) {
      con = msg_open(PROCID_POWERD, n);
      if (con < 0) {
	 snprintf(pswitch_str[n], PSWITCH_STATUS_STRLEN, "%s", "Unknown");
	 continue;
      } else {
	 /*
	  * Construct a message to send to the power daemon.
	  */
	 msghdr.command = PSWITCH_QUERY;
	 msghdr.length = 0;
	 if (msg_send(con, &msghdr, sizeof(msghdr)) < 0) {
	    snprintf(pswitch_str[n], PSWITCH_STATUS_STRLEN, "%s", "Unknown");
	    msg_close(con);
	    continue;
	 }
	 rc = msg_receive_timeout(con, &pswitch_msg, sizeof(pswitch_msg), &auth, 2);
	 if (rc == 0) {
	    snprintf(pswitch_str[n], PSWITCH_STATUS_STRLEN, "%s", "Timeout");
	    msg_close(con);
	    continue;
	 }
	 if (rc < 0) {
	    snprintf(pswitch_str[n], PSWITCH_STATUS_STRLEN, "%s", "Error");
	    msg_close(con);
	    continue;
	 }
	 if (rc != sizeof(pswitch_msg)) {
	    snprintf(pswitch_str[n], PSWITCH_STATUS_STRLEN, "%s", "Unknown");
	    msg_close(con);
	    continue;
	 }
	 msg_close(con);
	 if (pswitch_msg.status) {
	    snprintf(pswitch_str[n], PSWITCH_STATUS_STRLEN, "%s", 
		     strerror(pswitch_msg.status));
	 } else {
	    snprintf(pswitch_str[n], PSWITCH_STATUS_STRLEN, "%s", "Good");
	 }
      }
   }
   
   printf("Content-type: text/html\n\n");
   printf("<html>\n");
   
   printf("<head>\n");
   
   printf("<title>Kimberlite status</title>\n");

   printf("<meta http-equiv=\"refresh\" content=\"10; URL=clumon.cgi\" />\n");
   
   printf("</head>\n");
   
   printf("<body bgcolor=\"#ffffff\">\n");
   
   printf("<table width=\"100%%\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\">\n");
   
   printf("<tr>\n");
   printf("<td align=\"left\"><a href=\"http://oss.mclinux.com/kimberlite\"><img src=\"images/kimberlite.gif\" height=\"102\" width=\"270\" border=\"0\" alt=\"Kimberlite\" /></a></td>\n");
   
   printf("<td align=\"right\"><a href=\"http://www.mclinux.com\"><img src=\"images/mcl_logo.gif\" height=\"86\" width=\"200\" border=\"0\" alt=\"Mission Critical Linux\" /></a></td>\n");
   printf("</tr>\n");
   
   printf("<tr><td colspan=\"2\" height=\"5\">&nbsp;</td></tr>\n");
   
   rc = CFG_Get((char *)BABEL_CLUSTER_NAME, defval, &value);
   
   while (strstr(value, "&")) {
      ptrR = strstr(value, "&");
      memcpy(ptrR, "+", strlen("+"));
   }
   
   printf("<tr><td colspan=\"2\" align=\"center\"><b>%s</b></td></tr>\n", value);
   
   printf("</table>\n");
   
   printf("<table width=\"100%%\" border=\"0\" cellpadding=\"0\" cellspacing=\"10\">\n");
   
   printf("<tr>\n");
   
   printf("<td>\n");
   printf("<!-- member 0 services -->\n");
   
   printf("<table width=\"100%%\" border=\"0\" cellpadding=\"1\" cellspacing=\"0\">\n");
   
   printf("<tr>\n");
   printf("<td bgcolor=\"#000000\" width=\"100%%\">\n");
   
   printf("<table width=\"100%%\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\">\n");
   
   printf("<tr>\n");
   printf("<td bgcolor=\"#897da0\" align=\"center\"><font color=\"#ffffff\"><b>Services on Member 0</b></font></td>\n");
   printf("</tr>\n");
   
   printf("<tr>\n");
   printf("<td bgcolor=\"#dddddd\">\n");

   
   for (s = MIN_SERVICE; s < MAX_SERVICES; s++) {
      if (serviceExists(s) != YES) {
	 continue;
      }
      
      if (getServiceStatus(s, &svc) < 0) {
	 continue;
      }
      if (svc.owner == 0) {
	 getSvcName(svc.id, &value);
	 printf("%s <br />\n", value);
      }
      
   }
   
   
   printf("</td>\n");
   printf(" </tr>\n");
   
   printf(" </table>\n");
   
   printf("</td>\n");
   printf("</tr>\n");
   
   printf("</table>\n");
   
   printf("</td>\n");
   
   printf("<td>\n");
   printf("<!-- power and channel info -->\n");
   
   printf("<table width=\"100%%\" border=\"0\" cellpadding=\"1\" cellspacing=\"0\">\n");
   
   printf("<tr>\n");
   printf(" <td bgcolor=\"#000000\" width=\"100%%\">\n");
   
   printf(" <table width=\"100%%\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\">\n");
   
   printf(" <tr>\n");
   printf(" <td colspan=\"5\" bgcolor=\"#897da0\" align=\"center\"><font color=\"#ffffff\"><b>Power status</b></font></td>\n");
   printf("</tr>\n");
   
   printf(" </table>\n");
   
   printf("</td>\n");
   printf("</tr>\n");
   
   printf("<tr><td width=\"100%%\">\n");
   
   printf("<table width=\"100%%\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\">\n");
   
   printf("<tr><td align=\"center\"><b>%s</b></td>", cfg->nodes[0].name);
   printf("<td align=\"center\"><b>%s</b></td></tr>", cfg->nodes[1].name);
   
   printf("<tr>\n");
   
   if (strstr(pswitch_str[0], "Good")) {
      sprintf(image_name, "%s", "i_ok.gif");
   } else if (strstr(pswitch_str[0], "On")) {
      sprintf(image_name, "%s", "i_ok.gif");
   } else if (strstr(pswitch_str[0], "Unknown")) {
      sprintf(image_name, "%s", "i_wrn.gif");
   } else {
      sprintf(image_name, "%s", "i_err.gif");
   }
   
   printf("<td align=\"center\"><img src=\"images/%s\" height=\"31\" width=\"30\" border=\"0\" alt=\"Power\" /> <br /> %s </td>\n", image_name,  pswitch_str[0]);
   
   if (strstr(pswitch_str[1], "Good")) {
      sprintf(image_name, "%s", "i_ok.gif");
   } else if (strstr(pswitch_str[1], "On")) {
      sprintf(image_name, "%s", "i_ok.gif");
   } else if (strstr(pswitch_str[1], "Unknown")) {
      sprintf(image_name, "%s", "i_wrn.gif");
   } else {
      sprintf(image_name, "%s", "i_err.gif");
   }
   
   printf("<td align=\"center\"><img src=\"images/%s\" height=\"31\" width=\"30\" border=\"0\" alt=\"Power\" /> <br /> %s </td>\n", image_name,  pswitch_str[1]);
   
   printf("</tr></table>\n");
   
   printf("</td></tr>\n");
   
   printf("</table>\n");
   
   // channels
   
   printf("<table width=\"100%%\" border=\"0\" cellpadding=\"1\" cellspacing=\"0\">\n");
   
   printf("<tr>\n");
   printf(" <td colspan=\"3\" bgcolor=\"#000000\" width=\"100%%\">\n");
   
   printf(" <table width=\"100%%\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\">\n");
   
   printf(" <tr>\n");
   printf(" <td bgcolor=\"#897da0\" align=\"center\"><font color=\"#ffffff\"><b>Channel status</b></font></td>\n");
   printf("</tr>\n");
   
   printf(" </table>\n");
   
   printf("</td>\n");
   printf("</tr>\n");
   
   
   for (c = 0; c < cfg->num_chans; c++) {
      
      if (chan_state) {
	 if (chan_state[c].state) {
	    sprintf(image_name, "%s", "i_ok.gif");
	    } else {
	       sprintf(image_name, "%s", "i_wrn.gif");
	    }
      }
      else {
	 sprintf(image_name, "%s", "i_err.gif");
      }

      printf("<tr><td align=\"right\">%s</td>", cfg->nodes[0].chans[c].dev.serial.name);
      printf("<td align=\"center\"><img src=\"images/arrow_l.gif\" height=\"31\" width=\"48\" border=\"0\" alt=\"\" />");
      printf("<img src=\"images/%s\" height=\"31\" width=\"30\" border=\"0\" alt=\"Channel Status\" />", image_name);
      printf("<img src=\"images/arrow_r.gif\" height=\"31\" width=\"48\" border=\"0\" alt=\"\" /></td>");
      printf("<td align=\"left\">%s</td></tr>\n", cfg->nodes[1].chans[c].dev.serial.name);
   }
   
   
   
   printf("</table>\n");
   
   printf("</td>\n");
   
   printf("<td>\n");
   printf("<!-- member 1 services -->\n");
   
   printf(" <table width=\"100%%\" border=\"0\" cellpadding=\"1\" cellspacing=\"0\">\n");
   
   printf(" <tr>\n");
   printf("<td bgcolor=\"#000000\" width=\"100%%\">\n");
   
   printf("<table width=\"100%%\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\">\n");
   
   printf("<tr>\n");
   printf("<td bgcolor=\"#897da0\" align=\"center\"><font color=\"#ffffff\"><b>Services on Member 1</b></font></td>\n");
   printf(" </tr>\n");
   
   printf("<tr>\n");
   printf("<td bgcolor=\"#dddddd\">\n");

   for (s = MIN_SERVICE; s < MAX_SERVICES; s++) {
      if (serviceExists(s) != YES) {
	 continue;
      }
      
      if (getServiceStatus(s, &svc) < 0) {
	 continue;
      }
      if (svc.owner == 1) {
	 getSvcName(svc.id, &value);
	 printf("%s <br />\n", value);
      }
      
   }
   
   printf(" </td>\n");
   printf(" </tr>\n");
   
   printf(" </table>\n");
   
   printf(" </td>\n");
   printf(" </tr>\n");
   
   printf("</table>\n");
   
   printf("</td>\n");
   
   printf("</tr>\n");
   
   printf("<tr>\n");
   printf("<td colspan=\"3\" height=\"10\">&nbsp;</td>\n");
   printf("</tr>\n");
   
   printf("<tr>\n");
   printf("<td colspan=\"3\">\n");
   printf("<!-- non-running services -->\n");
   printf("<table width=\"100%%\" border=\"0\" cellpadding=\"1\" cellspacing=\"0\">\n");
   
   printf("<tr>\n");
   printf("<td bgcolor=\"#000000\" width=\"100%%\">\n");
   
   printf("<table width=\"100%%\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\">\n");
   
   printf("<tr>\n");
   printf("<td colspan=\"2\" bgcolor=\"#897da0\" align=\"center\"><font color=\"#ffffff\"><b>Non running services</b></font></td>\n");
   printf("</tr>\n");
   
   printf("<tr>\n");
   printf("<td bgcolor=\"#cccccc\"><b>Service</b></td><td bgcolor=\"#cccccc\"><b>Status</b></td>\n");
   printf(" </tr>\n");
   
   for (s = MIN_SERVICE; s < MAX_SERVICES; s++) {
      if (serviceExists(s) != YES) {
	 continue;
      }
      
      if (getServiceStatus(s, &svc) < 0) {
	 continue;
      }
      if (svc.owner == NODE_ID_NONE) {
	 
	 getSvcName(svc.id, &value);
	 
	 printf("<tr><td bgcolor=\"#dddddd\">%s</td>\n", value);
	 printf("<td bgcolor=\"dddddd\">%s</td></tr>\n", serviceStateStrings[svc.state]);
	 
      }
      
   }
   
   
   printf("</table>\n");
   
   printf(" </td>\n");
   printf(" </tr>\n");
   
   printf("</table>\n");
   printf("</td>\n");
   printf("</tr>\n");
   
   printf("</table>\n");
   
   printf("</body>\n");
   
   if (cfg != NULL)
	free(cfg);

   exit(0);
}
