#!/usr/bin/ksh


#  Copyright Mission Critical Linux, 2000

#  Kimberlite is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation; either version 2, or (at your option) any
#  later version.

#  Kimberlite is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with Kimberlite; see the file COPYING.  If not, write to the
#  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
#  MA 02139, USA.
#
# $Revision: 1.9 $
#
# Author: Gregory P. Myrdal <Myrdal@MissionCriticalLinux.Com>
#
#------------------------------------------------------------

#
# Service resource action script to be used as a template.
#

#---------------------------------------------------------------------------
# Global variables
#---------------------------------------------------------------------------

export PATH=/usr/sbin:/sbin:/bin:/usr/sbin:/usr/bin:$PATH

MYNAME=$(basename $0)
KSH_LIB=$(dirname $0)/../ksh_lib

LIBRARIES="\
	$KSH_LIB/globals.ksh \
	$KSH_LIB/log.ksh \
	$KSH_LIB/lock.ksh \
	$KSH_LIB/user.ksh \
	$KSH_LIB/nfs.ksh \
	$KSH_LIB/device.ksh \
	$KSH_LIB/svcdb.ksh \
	$KSH_LIB/ip.ksh \
"

for library in $LIBRARIES
do
	if [ -f $library ]; then
	  . $library
	else
	  logAndPrint $LOG_ERR "$MYNAME Error: Cannot find $library" | tee > /dev/console
	  return $FAIL
	fi
done

#---------------------------------------------------------------------------
# Functions
#---------------------------------------------------------------------------
printUsage() {
	logAndPrint $LOG_ERR "Usage: $MYNAME serviceID"
}

#---------------------------------------------------------------------------
# Main
#---------------------------------------------------------------------------

if [ $# -ne 1 ]; then
	printUsage
	exit 1
fi

typeset SVC_ID=$1
typeset SVC_NAME

SVC_NAME=$(getSvcName $DB $SVC_ID)
case $? in
0)  : ;;	# found it
*)  logAndPrint $LOG_ERR "\
Cannot get service name for service entry $SVC_ID, err=$?"
    exit 1 ;;
esac

logAndPrint $LOG_NOTICE "Stopping service $SVC_NAME ..."

stopUser
if [ $? -ne $SUCCESS ]; then
  logAndPrint $LOG_ERR "Cannot stop user script for $SVC_NAME"
  exit 1
fi

stopIP
if [ $? -ne $SUCCESS ]; then
  logAndPrint $LOG_ERR "Cannot stop IP addresses for $SVC_NAME"
  exit 1
fi

stopNFS
if [ $? -ne $SUCCESS ]; then
  logAndPrint $LOG_ERR "Cannot stop NFS for $SVC_NAME"
  exit 1
fi

stopDevices
if [ $? -ne $SUCCESS ]; then
  logAndPrint $LOG_ERR "Cannot stop devices for $SVC_NAME"
  exit 1
fi

logAndPrint $LOG_NOTICE "Stopped service $SVC_NAME ..."
exit 0
