/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/
/*
 * $Id: clulog.c,v 1.6 2000/10/31 22:26:20 lawrence Exp $
 *
 * Copyright (C) 2000, Mission Critical Linux, LLC
 *
 * Author: Jeff Moyer <moyer@mclinux.com>
 * Description: Utility for logging arbitrary strings to the cluster log
 *              file via the logging daemon.
 */
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <getopt.h>
#include <string.h>
#include <sys/syslog.h>

#include <logger.h>
#include <msgsvc.h>
#include <parseconf.h>
#include <clusterdefs.h>
#include <svcmgr.h>

static char *config_file;

#define MAX_TOKENLEN   64
#define DFLT_LOGLEVEL  LOG_NOTICE   /* taken from msgsvc.h */

static const char *version __attribute__ ((unused)) = "$Revision: 1.6 $";

void
usage(char *progname)
{
    fprintf(stdout, "%s -s severity [-l priority_filter] [-n program name] \n"
	    "\t\t [-p pid] \"message text\"\n", progname);
    exit(0);
}


int
main(int argc, char **argv)
{
    char opt;
    int  severity = 7,
	 cmdline_loglevel = 0;/* set if we should not use the config file val*/
    char *logmsg, *value;
    char token[MAX_TOKENLEN];
    int  pid = 0;
    char *progname = NULL;
    int result;

    if (argc < 4)
	usage(argv[0]);

    while ((opt = getopt(argc, argv, "l:s:hp:n:")) != -1) {
	switch (opt) {
	case 'l':
	    clu_set_loglevel(atoi(optarg));
	    cmdline_loglevel = 1;
	    break;
	case 's':
	    severity = atoi(optarg);
	    break;
	case 'p':
	    pid = atoi(optarg);
	    break;
	case 'n':
	    progname = strdup(optarg);
	    break;
	case 'h':
	    usage(argv[0]);
	default:
	    usage(argv[0]);
	}
    }

    logmsg = (char*)malloc(strlen(argv[argc-1])+2);
    strcpy(logmsg,argv[argc-1]);
    strcpy(&logmsg[strlen(argv[argc-1])], "\n\000");

    if (!config_file) {
	config_file = strdup(CLU_CONFIG_FILE);
    }

    if (CFG_ReadFile((char *) config_file) != CFG_OK) {
	fprintf(stderr, "clulog: could not read config file %s\n", config_file);
	exit(1);
    }
    free(config_file);

    if (!cmdline_loglevel) {
	/*
	 * Let's see what loglevel the SM is running at.
	 */
	snprintf(token, MAX_TOKENLEN, "%s%c%s",
		 SVCMGR_STR, CLU_CONFIG_SEPARATOR, SVCMGR_LOGLEVEL_STR);
	switch (CFG_Get(token, NULL, &value)) {
	case CFG_OK:
	    clu_set_loglevel(atoi(value));
	    break;
	case CFG_DEFAULT:
	default:
	    clu_set_loglevel(DFLT_LOGLEVEL);
	    break;
	}
    }
    result = clulog_pid(severity, pid, progname, logmsg);
    free(progname);
    return(result);
}
/*
 * Local variables:
 *  c-basic-offset: 4
 *  c-indent-level: 4
 *  tab-width: 8
 *  compile-command: "gcc -I../include -L../lib  clulog.c -o clulog -lmetaconfig -lmsg -llogger "
 * End:
 */

