/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, Stierand-LinuxIt                 *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef TINSTALLERSETTINGS_H
#define TINSTALLERSETTINGS_H

#include <qstring.h>

#include <kconfig.h>


#define CONFIG_GROUPGENERAL     "General"
#define CONFIG_GROUPSETTINGS    "KInstaller.Settings"
#define CONFIG_KEYKDEBASE          "kdeBase"
#define CONFIG_KEYTEMPDIR          "tempDir"
#define CONFIG_KEYPKGDIR           "pkgDir"
#define CONFIG_KEYSTORAGEDIR       "storageDir"
#define CONFIG_KEYKEEPPACKAGE      "keepPackage"
#define CONFIG_KEYUSECATEGORIES    "useCategories"
#define CONFIG_KEYUSECONFIGOPTIONS "useConfigureOptions"
#define CONFIG_KEYUSECONFIGOPTIONS "useConfigureOptions"
#define CONFIG_KEYCONFIGOPTIONS    "configureOptions"
#define CONFIG_KEYINSTALLTYPE      "installType"
#define CONFIG_KEYKEEPFILES        "keepInstallfiles"
#define CONFIG_KEYPACKKAGETYPE     "packageType"


/**
  */
class TInstallerSettings {
  public:
    typedef enum {
      Make = 1,
      Checkinstall
    } InstallType;
    typedef enum {
      RPM = 1,
      Debian,
      Slackware
    } PackageType;

    TInstallerSettings();
    ~TInstallerSettings();

    bool readConfig(KConfig * config);
    bool writeConfig(KConfig * config);
    
    /**
     * Returns the base directory of KDE
     */
    QString KDEBase();
    void setKDEBase(const QString & dir);

    /**
     * Returns the persistence type. This is either
     * temporary or persistent.
     */
    bool keepPackage();
    void setKeepPackage(bool keep);
    
    /**
     * Returns the storage directory
     */
    QString storageDir();
    void setStorageDir(const QString & dir);

    /**
     * Returns/sets the 'use categories' option
     */
    bool useCategories();
    void setUseCategories(bool use);
    
    /**
     * Wether addtional configure options should be used.
     */
    bool useConfigureOptions();
    void setUseConfigureOptions(bool use);

    /**
     * Addtional configure options
     */
    QString configureOptions();
    void setConfigureOptions(const QString & opts);

    /**
     * Returns/sets the installation type. This is either
     * 'make' or 'checkinstall'.
     */
    InstallType installType();
    void setInstallType(InstallType type);
    
    /**
     */
    bool keepInstallfiles();
    void setKeepInstallfiles(bool keep);

    /**
     * Returns/sets the package type.
     */
    PackageType packageType();
    void setPackageType(PackageType type);

  private:
    // the base directory of KDE
    QString m_kdeBaseDir;
    // the persistence type of packages.
    bool m_keepPackage;
    // the storage directory
    QString m_storageDir;
    bool m_useCategories;
    bool m_useConfigureOptions;
    QString m_configureOptions;
    InstallType m_installType;
    bool m_keepInstallfiles;
    PackageType m_packageType;
};

#endif
