#ifndef __njb_h__
#define __njb_h__

// kionjb
#include "playlist.h"
#include "track.h"

// kde
#include <kurl.h>
#include <kio/global.h>
#include <kio/slavebase.h>

// qt
#include <qcstring.h>
#include <qstring.h>

// libnjb
#include <libnjb.h>

// sqlite
#include <sqlite.h>


class kio_njbProtocol : public KIO::SlaveBase
{

public:
	kio_njbProtocol( const QCString& pool_socket, const QCString& app_socket);
	virtual ~kio_njbProtocol();
	virtual void closeConnection();
	virtual void del( const KURL& url, bool isfile);
	virtual void get( const KURL& url);
	virtual void listDir( const KURL& url);
	virtual void put( const KURL& url,
			int permissions, bool overwrite, bool resume);
	virtual void copy( const KURL& src, const KURL& dst,
			int permissions, bool overwrite);
	virtual void stat( const KURL& url);
	void dataQString( const QString& string);

protected:
	KIO::UDSEntry createUDSEntry( const KURL& url);
	KIO::UDSEntry createUDSEntry( const KURL& url, const QString& filename);
	void err( int status, const QString& msg);
	int open();
	int capture();
	int connect();
	int disconnect();

	int getAlbum( const KURL& url);
	int getEtc( const KURL& url);
	int getPlaylist( const KURL& url);
	int getTrack( const KURL& url);
	int delEtc( const KURL& url);
	int delPlaylist( const KURL& url);
	int delTrack( const KURL& url);
	int putEtc( const KURL& url);
	int putPlaylist( const KURL& url);
	int putTrack( const KURL& url, bool overwrite);
	int copyTrack( const KURL& src, const KURL& dst, bool overwrite);
	int listAlbums( const KURL& url);
	int listAll( const KURL& url);
	int listArtists( const KURL& url);
	int listArtist( const KURL& url);
	int listEtc( const KURL& url);
	int listPlaylists( const KURL& url);
	int listRoot( const KURL& url);

	// cache
	int cacheOpen( void);
	int cacheNew( void);
	int cacheClose( void);
	int cacheDel( const Track& track);
	int cacheTrack( const Track& track);
	int cachePlaylists( void);
	int cacheTracks( void);
	int cacheLibrary( bool force = false);
	bool trackById( Track& track, unsigned id);
	bool trackByFilename( Track& track, const QString& filename);

private:
	QString m_errMsg;

	njb_t* m_njb;
	bool m_captured;
	sqlite* m_db;
	int m_libcount;

	friend class Playlist;
};


#endif
