/***************************************************************************
                          track.cpp  -  description
                             -------------------
    begin                : 2001-10-13
    copyright            : (C) 2001 by Shaun Jackman
    email                : sjackman@debian.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

static const char* rcsid __attribute__((unused)) =
"$Id: track.cpp,v 1.10 2004/04/07 17:01:18 tsirc Exp $";


// qt
#include <qregexp.h>

// kde
#include <kdebug.h>

// libid3
#include <id3/tag.h>
#include <id3/misc_support.h>

// kionjb
#include "genre.h"
#include "track.h"


/* ------------------------------------------------------------------------ */
Track::Track( char** result)
{
	id = atoi( result[ 0]);
	size = atoi( result[ 1]);
	duration = atoi( result[ 2]);
	tracknum = atoi( result[ 3]);
	genre = result[ 4];
	artist = result[ 5];
	album = result[ 6];
	title = result[ 7];
	codec = result[ 8];
	filename = result[ 9];
}


/* ------------------------------------------------------------------------ */
Track::Track( songid_t* song)
{
	songid_frame_t* frame;

	id = song->trid;
	size = songid_size( song);
	duration = songid_length( song);
	tracknum = songid_track( song);

	frame = songid_findframe( song, FR_GENRE);
	if( frame)
		genre = QCString( (char*)frame->data, frame->datasz);
	else
		genre = "(none)";

	frame = songid_findframe( song, FR_ARTIST);
	if( frame) {
		artist = QCString( (char*)frame->data, frame->datasz);
		artist.replace( QRegExp( "/"), "-");
	}

	frame = songid_findframe( song, FR_ALBUM);
	if( frame) {
		album = QCString( (char*)frame->data, frame->datasz);
		album.replace( QRegExp( "/"), "-");
	} else
		album = "<Unknown>";

	frame = songid_findframe( song, FR_TITLE);
	if( frame) {
		title = QCString( (char*)frame->data, frame->datasz);
		title.replace( QRegExp( "/"), "-");
	}

	year = songid_year( song);

	frame = songid_findframe( song, FR_CODEC);
	if( frame)
		codec = QCString( (char*)frame->data, frame->datasz).lower();
	else
		codec = "mp3";

	frame = songid_findframe( song, FR_FNAME);
	if( frame)
		filename = QCString(  (char*)frame->data, frame->datasz);
	else
		filename = artist + " - " + title + "." + codec;
}


/* ------------------------------------------------------------------------ */
Track::Track( ID3_Tag& tag)
{
	// id, size, duration
	tracknum = ID3_GetTrackNum( &tag);

	genre = ID3_GetGenre( &tag);
	if( genre) {
		if( genre[0] == '(') {
			// convert numbered ID3v1 genre to text.
			// e.g. "(35)" to "House".
			genre = GENRE_DESCRIPTION(
					genre.mid( 1, genre.length()-1).toInt());
		}
	} else
		genre = "none";

	artist = ID3_GetArtist( &tag);
	if( !artist) {
		kdDebug( 7182) << "Track: empty artist" << endl;
		artist = "unknown";
	}

	album = ID3_GetAlbum( &tag);
	if( !album)
		album = "<Unknown>";

	title = ID3_GetTitle( &tag);
	if( !title) {
		kdDebug( 7182) << "Track: empty title" << endl;
		title = "unknown";
	}

	year = ID3_GetYear( &tag);

	codec = "mp3";
	// filename
}
