#include <string.h>
#include <glib-object.h>
#include <glib.h>

#include "kpsportentry.h"

#include "../kppresetdataitem.h"
#include "../kppresetdata.h"
#include "../kipina-i18n.h"


#define SPORT_MENU_CHOOSE    "Choose a Sport"
#define SPORT_MENU_OTHER   "Other"

static void         kp_sport_entry_class_init         (KPSportEntryClass *klass);
static void         kp_sport_entry_init               (KPSportEntry *bar);
static void         kp_sport_entry_finalize           (GObject *object);


static void         sport_box_changed_cb              (GtkComboBox *box,
                                                       KPSportEntry *entry);
static void         sport_entry_changed_cb            (GtkEditable *editable,
                                                       KPSportEntry *entry);


typedef struct KPSportEntryPrivateData_
{
  GtkWidget   *sport_entry;
  gchar       *sport;
} KPSportEntryPrivateData;

#define KP_SPORT_ENTRY_PRIVATE_DATA(widget) (((KPSportEntryPrivateData*) \
      (KP_SPORT_ENTRY (widget)->private_data)))



GType
kp_sport_entry_get_type (void)
{
  static GType        kp_sport_entry_type = 0;

  if (!kp_sport_entry_type) {
    static const GTypeInfo kp_sport_entry_info = {
      sizeof (KPSportEntryClass),
      NULL,
      NULL,
      (GClassInitFunc) kp_sport_entry_class_init,
      NULL,
      NULL,
      sizeof (KPSportEntry),
      0,
      (GInstanceInitFunc) kp_sport_entry_init,
      NULL
    };
    kp_sport_entry_type = g_type_register_static (GTK_TYPE_VBOX,
                                                 "KPSportEntry",
                                                 &kp_sport_entry_info, 0);
  }
  return kp_sport_entry_type;
}


static void
kp_sport_entry_class_init (KPSportEntryClass *klass)
{
  GObjectClass *object_class;

  object_class = G_OBJECT_CLASS (klass);
  object_class->finalize = kp_sport_entry_finalize;
}


static void
kp_sport_entry_init (KPSportEntry *entry)
{
  KPSportEntryPrivateData *p_data;
  GtkComboBox *box;
  GSList *list;
  
  entry->private_data = g_new (KPSportEntryPrivateData, 1);
  p_data = KP_SPORT_ENTRY_PRIVATE_DATA (entry);
  p_data->sport = NULL;

  /* Create the box */
  box = GTK_COMBO_BOX (gtk_combo_box_new_text ());
  gtk_box_pack_start (GTK_BOX (entry), GTK_WIDGET (box), FALSE, TRUE, 0);
  gtk_widget_show (GTK_WIDGET (box));
  
  list = kp_preset_data_get_items (KP_PRESET_DATA_SPORT);
  for (; list; list = list->next)
    gtk_combo_box_append_text (box, KP_PRESET_DATA_ITEM (list->data)->name);

  gtk_combo_box_prepend_text (box, _(SPORT_MENU_CHOOSE));
  gtk_combo_box_append_text (box, _(SPORT_MENU_OTHER));

  gtk_combo_box_set_active (box, 0);
  
  /* Create the entry, but don't show it yet */
  p_data->sport_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (entry), p_data->sport_entry, FALSE, TRUE, 0);

  g_signal_connect (G_OBJECT (box), "changed",
                    G_CALLBACK (sport_box_changed_cb), entry);
  g_signal_connect (G_OBJECT (p_data->sport_entry), "changed",
                    G_CALLBACK (sport_entry_changed_cb), entry);
}

static void
kp_sport_entry_finalize (GObject *object)
{
  KPSportEntryPrivateData *p_data;
  
  p_data = KP_SPORT_ENTRY_PRIVATE_DATA (object);

  g_free (KP_SPORT_ENTRY (object)->private_data);
}

/**
 * kp_sport_entry_new:
 * @log: A #KPTrainingLog, can be NULL
 *
 * Create a new instance of #KPSportEntry.
 */
GtkWidget *
kp_sport_entry_new (void)
{
  return g_object_new (kp_sport_entry_get_type (), NULL);
}


G_CONST_RETURN gchar *
kp_sport_entry_get_sport (KPSportEntry *entry)
{
  KPSportEntryPrivateData *p_data;
  p_data = KP_SPORT_ENTRY_PRIVATE_DATA (entry);
  return p_data->sport;
}


static void
sport_box_changed_cb (GtkComboBox *box, KPSportEntry *entry)
{
  KPSportEntryPrivateData *p_data;
  gchar *item;
  
  p_data = KP_SPORT_ENTRY_PRIVATE_DATA (entry);

  item = gtk_combo_box_get_active_text (box);
  if (item) {
    /* Check if the item is not actually a sport */
    if (strcmp (item, _(SPORT_MENU_CHOOSE)) == 0) {
      if (p_data->sport)
        g_free (p_data->sport);
      p_data->sport = NULL;
      return;
    }
    else if (strcmp (item, _(SPORT_MENU_OTHER)) == 0) {
      gtk_widget_show (p_data->sport_entry);
      return;
    }
    if (p_data->sport)
      g_free (p_data->sport);
    p_data->sport = g_strdup (item);
  }
}

    
static void
sport_entry_changed_cb (GtkEditable *editable, KPSportEntry *entry)
{
  KPSportEntryPrivateData *p_data;
  const gchar *text;
  
  p_data = KP_SPORT_ENTRY_PRIVATE_DATA (entry);
  text = gtk_entry_get_text (GTK_ENTRY (editable));
  
  if (text) {
    if (p_data->sport)
      g_free (p_data->sport);
    p_data->sport = g_strdup (text); 
  }
}
