#include <gtk/gtk.h>
#include <glib-object.h>

#include "../kpcalendarentry.h"
#include "../kipina-i18n.h"

#include "kpviewmodel.h"
#include "kpviewpopupmodel.h"

GType
kp_view_popup_model_get_type ()
{
  static GType kp_view_popup_model_type = 0;

  if (!kp_view_popup_model_type) {
    static const GTypeInfo kp_view_popup_model_info = {
      sizeof (KPViewPopupModelIface),
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL
    };
    kp_view_popup_model_type = g_type_register_static (G_TYPE_INTERFACE,
                                                      "KPViewPopupModel",
                                                      &kp_view_popup_model_info,
                                                       0);
    g_type_interface_add_prerequisite (kp_view_popup_model_type, 
                                       KP_TYPE_VIEW_MODEL);
  }
  return kp_view_popup_model_type;
}


KPCalendarEntry *
kp_view_popup_model_get_active_entry (KPViewPopupModel *model)
{
  return KP_VIEW_POPUP_MODEL_GET_CLASS (model)->get_active_entry (model);
}
