package kissme.vm.loaders;

import java.util.HashMap;
import java.util.zip.ZipFile;
import java.util.zip.ZipEntry;

import java.io.InputStream;
import java.io.File;

import java.io.IOException;


public class ZipClassLoader {

  private static HashMap zipfilesMap = new HashMap();
  
  /* we use this Object to cache the fact that it doesn't exist */
  private static final Object NO_ZIP_FILE = new Object();

  private static String fileSeparator;

  public static byte[] getClassData(String className, String loaderPath)
  {
    ZipFile zf = getZipFile(loaderPath);
    if (zf == null) {
      return null;
    }
    
    ZipEntry ze = (ZipEntry) zf.getEntry(className + ".class");
    if (ze != null) {
      int length = (int) ze.getSize();
      byte[] buffer = new byte[length];
      try {
	InputStream is = zf.getInputStream(ze);
	int haveread = 0;
	while (haveread < length) {
	  int res = is.read(buffer, haveread, (length - haveread));
	  if (res == -1) {
	    return null;
	  }
	  haveread += res;
	}
      }
      catch (IOException ex) {
	return null;
      }
      return buffer;
    }
    else {
      return null;
    }
  }

  private static ZipFile getZipFile(String loaderPath) 
  {
    Object hashResult = null;
    ZipFile zf = null;

    if ((hashResult = zipfilesMap.get(loaderPath)) == null) {
      /* we haven't cached this zip file yet */
      try {
	zf = new ZipFile(new File(loaderPath));
	zipfilesMap.put(loaderPath, zf);
	return zf;
      } 
      catch (IOException ex) {
	zipfilesMap.put(loaderPath, NO_ZIP_FILE);
	return null;
      }
    }
    else {
      if (hashResult == NO_ZIP_FILE) {
	return null;
      }
      else {
	return (ZipFile) hashResult;
      }
    }
  }

  public static String getResourceUrl(String name, String loaderPath)
  {
    ZipFile zf = getZipFile(loaderPath);
    if (zf == null) {
      return null;
    }

    ZipEntry ze = (ZipEntry) zf.getEntry(name);
    if (ze == null) {
      return null;
    }
    if (fileSeparator == null) {
      fileSeparator = System.getProperty("file.separator");
    }
    return "zip:file:" + loaderPath + "!" + name;
  }

}
