package hitme;

/**
 * This class encapsulates a bunch of static flags that enable /
 * disable subtests for known VM / class library bugs.
 */
public class BugFlags 
{
  // java.lang.Integer.decode() in Classpath 0.0.3 and earlier does
  // not support -ve numbers with a radix of 8 or 16.  This effects
  // the decode method of other integral types as well. 
  public static final boolean NEGATIVE_DECODE = false;
  
  // java.lang.Integer.decode(null) in Classpath 0.0.3 and earlier
  // throws NumberFormatException rather than NullPointerException.
  // This effects the decode method of other integral types as well.
  public static final boolean NULL_DECODE = false;
}
