package hitme;

import java.io.*;

/**
 * This logger implementation assumes that PrintStream output works
 **/ 
public class HitMeFullLogger implements HitMeLogger
{
  private PrintStream m_err;
  private PrintStream m_log;
  private boolean m_ok;
  
  
  public HitMeFullLogger(PrintStream err, PrintStream log) {
    m_err = err;
    m_log = log;
    m_ok = true;
  }

  public void check(boolean predicate, String msg) {
    if (!predicate) {
      errln(msg);
    }
  }

  public void errln(String msg) {
    m_err.println(msg);
    m_ok = false;
  }

  public void err(String msg) {
    m_err.print(msg);
    m_ok = false;
  }
  
  public void err(Throwable ex) {
    ex.printStackTrace(m_err);
    m_ok = false;
  }
  
  public void logln(String msg) {
    m_log.println(msg);
  }

  public void log(String msg) {
    m_log.print(msg);
  }
  
  public void log(Throwable ex) {
    ex.printStackTrace(m_log);
  }

  public void clear() {
    m_ok = true;
  }

  public boolean isOk() {
    return m_ok;
  }
}
