package hitme;

/**
 * A HitMeLogger dispatches error an non-error log messages, and
 * keeps track of the test's success or failure.
 */
public interface HitMeLogger 
{
  /**
   * Perform a subtest check.  If <b>predicate</b> is false, the
   * <b>msg</b> will be output to the error log.  In logger
   * implementations that keep track of subtest numbers, this method
   * denotes a new subtest. 
   **/
  public void check(boolean predicate, String msg);
  
  /**
   * Output a message followed by a newline, and set the error flag.
   * @param msg the message
   **/
  public void errln(String msg);
    
  /**
   * Output a message, and set the error flag.
   * @param msg the message
   **/
  public void err(String msg);
    
  /**
   * Output an exception and set the error flag.
   * @param ex the exception object
   **/
  public void err(Throwable ex);
    
  /**
   * Output a message followed by a newline.
   * @param msg the message
   **/
  public void logln(String msg);
    
  /**
   * Output a message.
   * @param msg the message
   **/
  public void log(String msg);
    
  /**
   * Output an exception.
   * @param ex the exception object
   **/
  public void log(Throwable ex);
    
  /**
   * Clear the error flag.
   **/
  public void clear();
    
  /**
   * @return true iff there has been no error (since the last call
   * to clear())
   **/
  public boolean isOk();

}
