package hitme;

/**
 * This logger implementation is designed to be used when stream io
 * cannot be trusted.  Errors are reported by calling System.exit()
 * with the subtest number as parameter.  Error messages are ignored
 * and all errors are (obviously) immediately fatal. <p>
 *
 * System.exit() does some security checks which might get in the way.
 * If that is the case, kissme currently allows you to call the
 * Runtime.exitInternal() method directly.  However, this is commented
 * out so that this code will compile against the Sun Java Runtime.
 **/
public class HitMeMinimalLogger implements HitMeLogger
{
  int m_subtestNo;
  
  public HitMeMinimalLogger() {
    m_subtestNo = 0;
  }

  public void check(boolean predicate, String msg) {
    if (predicate) {
      m_subtestNo++;
    }
    else {
      // Runtime.getRuntime().exitInternal(m_subtestNo);
      System.exit(m_subtestNo);
    }
  }

  public void errln(String msg) {
    // Runtime.getRuntime().exitInternal(m_subtestNo);
    System.exit(m_subtestNo);
  }
    
  public void err(String msg) {
    // Runtime.getRuntime().exitInternal(m_subtestNo);
    System.exit(m_subtestNo);
  }
  
  public void err(Throwable ex) {
    // Runtime.getRuntime().exitInternal(m_subtestNo);
    System.exit(m_subtestNo);
  }
  
  public void logln(String msg) {
  }

  public void log(String msg) {
  }
  
  public void log(Throwable ex) {
  }

  public void clear() {
    m_subtestNo = 0;
  }

  public boolean isOk() {
    return true;
  }
}
