package hitme;

import java.io.*;

/**
 * This class does HitMe commandline options processing and
 * encapsulates the resulting options.
 **/
public class HitMeOpts
{
  String m_caseListFileName = "hitme.tests";
  int m_paramPos;
  boolean m_ok;
  boolean m_isHelp;


  /**
   * Construct an options object based on the supplied argument list
   * @param args the command line arguments.
   **/
  HitMeOpts(String[] args) {
    m_paramPos = args.length;
    m_ok = true;
    for (int i = 0; i < args.length && m_ok; i++) {
      String opt = args[i];
      if (!opt.startsWith("-")) {
	m_paramPos = i;
	break;
      }
      if (opt.equals("-c") || opt.equals("--caselist")) {
	if (i++ < args.length) {
	  m_caseListFileName = args[i];
	}
	else {
	  m_ok = false;
	}
      }
      else if (opt.equals("-h") || opt.equals("--help")) {
	m_isHelp = true;
      }
    }
  }

  /** 
   * @return a BufferedReader for the test case list
   **/
  public BufferedReader getCaseListReader() throws IOException {
    FileReader r = new FileReader(m_caseListFileName);
    return new BufferedReader(r);
  }

  /**
   * @return true if the options parsing succeeded
   **/
  public boolean isOk() {
    return m_ok;
  }

  /**
   * @return true if the --help option has been supplied
   **/
  public boolean isHelp() {
    return m_isHelp;
  }

  /**
   * @return the offset in <b>args</b> of the first non-option
   * parameter.
   **/
  public int getParameterPos() {
    return m_paramPos;
  }

  /**
   * @return a synopsis of the options
   **/
  public String getShortHelp() {
    return "[-c | --caselist caselist] [--help]";
  }
  
  /**
   * @return detailed help for the options
   **/
  public String getLongHelp() {
    return "";
  }
}
