package hitme.basic.lang;

import java.io.*;

/**
 * Testing garbage collection / IO interactions.  Uses UNIX fifos 
 * (named pipes) to get read/write/open operations to block.
 */
public class GCAndIO extends hitme.HitMeTest
{
  boolean die = false;

  class Reader implements Runnable
  {
    public void run() 
    {
      try {
        BufferedReader r = 
	  new BufferedReader(new FileReader("/tmp/hitme-fifo-1"));
	while (r.readLine() != null) {
	}
	r.close();
      }
      catch (IOException ex) {
	ex.printStackTrace();
      }
      catch (Throwable ex) {
	ex.printStackTrace();
      }
    }
  }

  class Writer implements Runnable
  {
    public void run() 
    {
      try {
        FileWriter w = new FileWriter("/tmp/hitme-fifo-2");
	while (!die) {
	  w.write("Hello\n");
	}
      }
      catch (IOException ex) {
	ex.printStackTrace();
      }
      catch (Throwable ex) {
	ex.printStackTrace();
      }
    }
  }

  public String describe() {
    return "GC / IO interaction test";
  }
  
  public void test() 
  {
    Thread t1 = new Thread(new Reader());
    Thread t2 = new Thread(new Writer());
    t1.start();    
    t2.start();

    FileWriter fw = null;
    FileReader fr = null;
    try {
      fw = new FileWriter("/tmp/hitme-fifo-1");
      fr = new FileReader("/tmp/hitme-fifo-2");
    }
    catch (IOException ex) {
      ex.printStackTrace();
    }
    
    // Generate large amounts of garbage.  If something goes wrong with
    // the GC / thread synchro, we might expect GC to be blocked.

    for (int i = 0; i < 1000000; i++) {
      byte[] junk = new byte[16];
    }

    check(t1.isAlive(), "Reader thread died too soon");   
    check(t2.isAlive(), "Writer thread died too soon");

    die = true;
    try {
      for (int i = 0; i < 6; i++) {
	fr.read();
      }

      fw.close();  
      fr.close();
    }
    catch (IOException ex) {
      ex.printStackTrace();
    }

    try {
      t1.interrupt();      
      t2.interrupt();
      Thread.sleep(1000);
    }
    catch (Exception ex) {
    }

    check(!t1.isAlive(), "Reader thread not dead");  
    check(!t2.isAlive(), "Writer thread not dead");
  }
}
