package hitme.basic.lang;

/**
 * Testing behaviour when we run out of memory
 */
public class GCDeep extends hitme.HitMeTest 
{

  public class Link {
    private Link next;
    public Link(Link next) {
      this.next = next;
    }
  }

  public String describe() {
    return "GC test - marking and collecting deep structures";
  }
  
  public void test() {
    try {
      // Create a pathologically deep data structure.  If the collector
      // does niave recursive marking, this will require a very large
      // stack.
      Link chain = null;
      while (true) {
	chain = new Link(chain);
      }
    }
    catch (OutOfMemoryError er) {
      // By now the 'chain' is garbage.  Make sure we can collect it.
      int[] bigArray = new int[10000];
    }
  }
}
