package hitme.basic.types;

/**
 * Testing the 'byte' data type
 *
 * (Was kissme_test.ByteTest)
 */
public class ByteType extends hitme.HitMeTest {
  
  public static byte mb(int arg)
  {
    if (arg < 0 || arg > 255) {
      throw new RuntimeException("arg out of range");
    }
    if (arg > 127) {
      return (byte) ((byte) (arg - 256));
    }
    else {
      return (byte) arg;
    }
  }
  
  public int doit() 
  {
    for (int i = 0; i < 256; i++)  {
      check(mb(i) < 128, "mb(...) returns byte >= 128");
    }
    
    for (int i = -256; i < 256; i++) {
      check(((byte) i) < 128, "(byte) i >= 128");
    }
    return 0;
  }
  
  public static byte callme(byte a, byte b)
  {
    if ((a + b) < 50) {
      return (byte) (a + b);
    }
    else {
      return (byte) (a - b); 
    }
  }
  
  public void workit() 
  {
    byte a, b, c, d, e, f, g, h;
    
    a = -2;
    b = -3;
    c = -4;
    d = -5;
    e = 6;
    f = 7;
    g = 8;
    h = 9;
    
    a = (byte) (b + c + d + e + f + g + h);
    check(a == 18, "a != 18");
    h = (byte) callme(d, e);
    check(h == 1, "h != 1");
    
    byte[] mbarray = new byte[22];
    
    mbarray[0] = a;
    mbarray[1] = b;
    mbarray[2] = c;
    mbarray[3] = d;
    mbarray[4] = e;
    
    f = mbarray[0];
    g = mbarray[1];
    h = mbarray[2];
    
    check(f == 18, "f != 18");
    check(g == -3, "g != -3");
    check(h == -4, "h != -4");
  }
  
  public void test() 
  {
    // First the simple stuff
    byte b = -25;
    check(b == -25, "b != 25");
    check(b == (byte) -25, "b != (byte) 25");
    
    byte c = (256 - 255 + 1 - 25 - 2);
    check(c == -25, "c != 25");
    check(c == (byte) -25, "c != (byte) 25");
    
    // Now arrays
    byte[] barray = new byte[7];
    
    for (int i = -3; i < 3; i++){
      barray[i + 3] = (byte) i;
      byte d = barray[i + 3];
      check(i == d, "i != d");
    }
    
    workit();
    workit();
    doit();
    doit();
  }
  
  public String describe() {
    return "'byte' test";
  }
}
