package hitme.basic.types;

import hitme.BugFlags;

/**
 * Testing the 'Byte' class
 */
public class ByteWrapper extends hitme.HitMeTest {

  public void test() 
  {
    // Checking Byte.MIN_VALUE and Byte.MAX_VALUE
    check(Byte.MIN_VALUE < Byte.MAX_VALUE, 
	  "Byte.MIN_VALUE >= Byte.MAX_VALUE");
    // (Note: the cast is necessary because of Java promotion rules.)
    check(Byte.MIN_VALUE == (byte)(Byte.MAX_VALUE + 1), 
	  "Byte.MIN_VALUE != (byte)(Byte.MAX_VALUE + 1)");
	
    // Checking Byte.TYPE
    check(Byte.TYPE.getName().equals("byte"), "Byte.TYPE wrong");
	
    // Checking static Byte.toString(String)
    check(Byte.toString((byte) 0).equals("0"), "toString(0) failed");
    check(Byte.toString((byte) 1).equals("1"), "toString(1) failed");
    check(Byte.toString((byte) -1).equals("-1"), "toString(-1) failed");
    check(Byte.toString(Byte.MIN_VALUE).equals("-128"), 
	  "toString(MIN_VALUE) failed");
    check(Byte.toString(Byte.MAX_VALUE).equals("127"), 
	  "toString(Byte.MAX_VALUE) failed");
	
    // Checking Byte(byte)
    Byte b = new Byte((byte) 0);
    check(b.byteValue() == 0, "b.byteValue() != 0");
	
    // Checking Byte.equals(Byte);
    Byte b2 = new Byte((byte) 0);
    Byte b3 = new Byte((byte) 1);
    check(b.equals(b2), "!b.equals(b2)");
    check(!b.equals(b3), "b.equals(b3)");
    check(!b.equals(null), "b.equals(null)");
    check(!b.equals(this), "b.equals(this)");
	
    // Checking Byte.compareTo(Byte);
    check(b.compareTo(b2) == 0, "Byte(0).compareTo(Byte(0)) != 0)");
    check(b.compareTo(b3) < 0, "Byte(0).compareTo(Byte(1)) >= 0)");
    check(b3.compareTo(b) > 0, "Byte(1).compareTo(Byte(0)) <= 0)");

    // Checking Byte.compareTo(Object);
    Object o = b;
    Object o2 = b2;
    Object o3 = b3;
    check(b.compareTo(o2) == 0, "Byte(0).compareTo(Obj(0)) != 0)");
    check(b.compareTo(o3) < 0, "Byte(0).compareTo(Obj(1)) >= 0)");
    check(b3.compareTo(o) > 0, "Byte(1).compareTo(Obj(0)) <= 0)");
    try {
      b.compareTo(this);
      check(false, "no exception for Byte.compareTo(this)");
    } catch (ClassCastException ex) { /* */ }
    try {
      b.compareTo(null);
      check(false, "no exception for Byte.compareTo(null)");
    } catch (NullPointerException ex) { /* */ }
	
    // Checking Byte(String)
    Byte b4 = new Byte("0");
    check(b4.equals(b2), "!b4.equals(b2)");
    Byte b5 = new Byte("1");
    check(b5.equals(b3), "!b5.equals(b3)");
	
    // Checking static Byte.parseByte(String)
    check(Byte.parseByte("0") == 0, 
	  "Byte.parseByte(\"0\") != 0");
    check(Byte.parseByte("-0") == 0, 
	  "Byte.parseByte(\"-0\") != 0");
    check(Byte.parseByte("1") == 1, 
	  "Byte.parseByte(\"1\") != 1");
    check(Byte.parseByte("10") == 10, 
	  "Byte.parseByte(\"10\") != 10");
    check(Byte.parseByte("-1") == -1, 
	  "Byte.parseByte(\"-1\") != -1");
    check(Byte.parseByte("127") == 127, 
	  "Byte.parseByte(\"127\") != 127");
    check(Byte.parseByte("-128") == -128, 
	  "Byte.parseByte(\"-128\") != -128");
    try {
      Byte.parseByte("128");
      check(false, "no exception for Byte.parseByte(\"128\")");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.parseByte("-129");
      check(false, "no exception for Byte.parseByte(\"-129\")");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.parseByte("+1");
      check(false, "no exception for Byte.parseByte(\"+1\")");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.parseByte("1a");
      check(false, "no exception for Byte.parseByte(\"1a\")");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.parseByte("");
      check(false, "no exception for Byte.parseByte(\"\")");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.parseByte(null);
      check(false, "no exception for Byte.parseByte(null)");
    } catch (NumberFormatException ex) { /* */ }
	
    check(Character.MIN_RADIX == 2 && Character.MAX_RADIX == 36,
	  "radix limits wrong");

    // Checking static Byte.parseByte(String, 2)
    check(Byte.parseByte("0", 2) == 0, 
	  "Byte.parseByte(\"0\", 2) != 0");
    check(Byte.parseByte("-0", 2) == 0, 
	  "Byte.parseByte(\"-0\", 2) != 0");
    check(Byte.parseByte("1", 2) == 1, 
	  "Byte.parseByte(\"1\", 2) != 1");
    check(Byte.parseByte("10", 2) == 2, 
	  "Byte.parseByte(\"10\", 2) != 2");
    check(Byte.parseByte("-1", 2) == -1, 
	  "Byte.parseByte(\"-1\", 2) != -1");
    check(Byte.parseByte("1111111", 2) == 127, 
	  "Byte.parseByte(\"1111111\", 2) != 127");
    check(Byte.parseByte("-10000000", 2) == -128, 
	  "Byte.parseByte(\"-10000000\", 2) != -128");
    try {
      Byte.parseByte("2", 2);
      check(false, "no exception for Byte.parseByte(\"2\", 2)");
    } catch (NumberFormatException ex) { /* */ }
	
    // Checking static Byte.parseByte(String, 8)
    check(Byte.parseByte("0", 8) == 0, 
	  "Byte.parseByte(\"0\", 8) != 0");
    check(Byte.parseByte("-0", 8) == 0, 
	  "Byte.parseByte(\"-0\", 8) != 0");
    check(Byte.parseByte("1", 8) == 1, 
	  "Byte.parseByte(\"1\", 8) != 1");
    check(Byte.parseByte("10", 8) == 8, 
	  "Byte.parseByte(\"10\", 8) != 8");
    check(Byte.parseByte("-1", 8) == -1, 
	  "Byte.parseByte(\"-1\", 8) != -1");
    check(Byte.parseByte("177", 8) == 127, 
	  "Byte.parseByte(\"177\", 8) != 127");
    check(Byte.parseByte("-200", 8) == -128, 
	  "Byte.parseByte(\"-200\", 8) != -128");
    try {
      Byte.parseByte("8", 8);
      check(false, "no exception for Byte.parseByte(\"8\", 8)");
    } catch (NumberFormatException ex) { /* */ }
	
    // Checking static Byte.parseByte(String, 16);
    check(Byte.parseByte("0", 16) == 0, 
	  "Byte.parseByte(\"0\", 16) != 0");
    check(Byte.parseByte("-0", 16) == 0, 
	  "Byte.parseByte(\"-0\", 16) != 0");
    check(Byte.parseByte("1", 16) == 1, 
	  "Byte.parseByte(\"1\", 16) != 1");
    check(Byte.parseByte("10", 16) == 16, 
	  "Byte.parseByte(\"10\", 16) != 16");
    check(Byte.parseByte("-1", 16) == -1, 
	  "Byte.parseByte(\"-1\", 16) != -1");
    check(Byte.parseByte("7f", 16) == 127, 
	  "Byte.parseByte(\"7f\", 16) != 127");
    check(Byte.parseByte("7F", 16) == 127, 
	  "Byte.parseByte(\"7F\", 16) != 127");
    check(Byte.parseByte("-80", 16) == -128, 
	  "Byte.parseByte(\"-80\", 16) != -128");
    try {
      Byte.parseByte("G", 16);
      check(false, "no exception for Byte.parseByte(\"G\", 16)");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.parseByte("g", 16);
      check(false, "no exception for Byte.parseByte(\"g\", 16)");
    } catch (NumberFormatException ex) { /* */ }
	
    // Boundary cases for Byte.parseByte(String, radix);
    try {
      Byte.parseByte(null, 2);
      check(false, "no exception for Byte.parseByte(null, 2)");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.parseByte("", 2);
      check(false, "no exception for Byte.parseByte(\"\", 2)");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.parseByte("0", 1);
      check(false, "no exception for Byte.parseByte(\"0\", 1)");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.parseByte("0", 37);
      check(false, "no exception for Byte.parseByte(\"0\", 37)");
    } catch (NumberFormatException ex) { /* */ }

    // Checking static Byte.decode(String);
    // Byte.decode(String) - Radix 10
    check(Byte.decode("0").byteValue() == 0, 
	  "Byte.decode(\"0\") != 0");
    check(Byte.decode("-0").byteValue() == 0, 
	  "Byte.decode(\"-0\") != 0");
    check(Byte.decode("1").byteValue() == 1, 
	  "Byte.decode(\"1\") != 1");
    check(Byte.decode("-1").byteValue() == -1, 
	  "Byte.decode(\"-1\") != -1");
    check(Byte.decode("-19").byteValue() == -19, 
	  "Byte.decode(\"-19\") != -19");
    check(Byte.decode("20").byteValue() == 20, 
	  "Byte.decode(\"20\") != 20");
    check(Byte.decode("127").byteValue() == 127, 
	  "Byte.decode(\"127\") != 127");
    check(Byte.decode("-128").byteValue() == -128, 
	  "Byte.decode(\"-128\") != -128");
    // Byte.decode(String) - Radix 8 (0ooo)
    check(Byte.decode("00").byteValue() == 0, 
	  "Byte.decode(\"00\") != 0");
    check(Byte.decode("01").byteValue() == 1, 
	  "Byte.decode(\"01\") != 1");
    check(Byte.decode("020").byteValue() == 16, 
	  "Byte.decode(\"020\") != 16");
    check(Byte.decode("0177").byteValue() == 127, 
	  "Byte.decode(\"0177\") != 127");
    if (!BugFlags.NEGATIVE_DECODE) {
      check(Byte.decode("-00").byteValue() == 0, 
	    "Byte.decode(\"-00\") !=` 0");
      check(Byte.decode("-01").byteValue() == -1, 
	    "Byte.decode(\"-01\") != -1");
      check(Byte.decode("-017").byteValue() == -15, 
	    "Byte.decode(\"-017\") != -15");
      check(Byte.decode("-0200").byteValue() == -128, 
	    "Byte.decode(\"-0200\") != -128");   
    }
    // Byte.decode(String) - Radix 16 (0x)
    check(Byte.decode("0x0").byteValue() == 0, 
	  "Byte.decode(\"0x0\") != 0");
    check(Byte.decode("0x1").byteValue() == 1, 
	  "Byte.decode(\"0x1\") != 1");
    check(Byte.decode("0x20").byteValue() == 32, 
	  "Byte.decode(\"0x20\") != 32");
    check(Byte.decode("0x7f").byteValue() == 127, 
	  "Byte.decode(\"0x7f\") != 127");
    if (!BugFlags.NEGATIVE_DECODE) {
      check(Byte.decode("-0x0").byteValue() == 0, 
	    "Byte.decode(\"-0x0\") !=` 0");
      check(Byte.decode("-0x1").byteValue() == -1, 
	    "Byte.decode(\"-0x1\") != -1");
      check(Byte.decode("-0x19").byteValue() == -25, 
	    "Byte.decode(\"-0x19\") != -25");
      check(Byte.decode("-0x80").byteValue() == -128, 
	    "Byte.decode(\"-0x80\") != -128");   
    }
    // Byte.decode(String) - Radix 16 (0X)
    check(Byte.decode("0X0").byteValue() == 0, 
	  "Byte.decode(\"0X0\") != 0");
    check(Byte.decode("0X1").byteValue() == 1, 
	  "Byte.decode(\"0X1\") != 1");
    check(Byte.decode("0X20").byteValue() == 32, 
	  "Byte.decode(\"0X20\") != 32");
    check(Byte.decode("0X7f").byteValue() == 127, 
	  "Byte.decode(\"0X7f\") != 127");
    if (!BugFlags.NEGATIVE_DECODE) {
      check(Byte.decode("-0X0").byteValue() == 0, 
	    "Byte.decode(\"-0X0\") !=` 0");
      check(Byte.decode("-0X1").byteValue() == -1, 
	    "Byte.decode(\"-0X1\") != -1");
      check(Byte.decode("-0X19").byteValue() == -25, 
	    "Byte.decode(\"-0X19\") != -25");
      check(Byte.decode("-0X80").byteValue() == -128, 
	    "Byte.decode(\"-0X80\") != -128");   
    }
    // Byte.decode(String) - Radix 16 (#)
    check(Byte.decode("#0").byteValue() == 0, 
	  "Byte.decode(\"#0\") != 0");
    check(Byte.decode("#1").byteValue() == 1, 
	  "Byte.decode(\"#1\") != 1");
    check(Byte.decode("#20").byteValue() == 32, 
	  "Byte.decode(\"#20\") != 32");
    check(Byte.decode("#7f").byteValue() == 127, 
	  "Byte.decode(\"#7f\") != 127");
    if (!BugFlags.NEGATIVE_DECODE) {
      check(Byte.decode("-#0").byteValue() == 0, 
	    "Byte.decode(\"-#0\") !=` 0");
      check(Byte.decode("-#1").byteValue() == -1, 
	    "Byte.decode(\"-#1\") != -1");
      check(Byte.decode("-#19").byteValue() == -25, 
	    "Byte.decode(\"-#19\") != -25");
      check(Byte.decode("-#80").byteValue() == -128, 
	    "Byte.decode(\"-#80\") != -128");   
    }
    // Byte.decode(String) - Out of range values
    try {
      Byte.decode("#80");
      check(false, "No exception for Byte.decode(\"#80\")");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.decode("-129");
      check(false, "No exception for Byte.decode(\"-129\")");
    } catch (NumberFormatException ex) { /* */ }
    // Byte.decode(String) - Boundary cases
    try {
      Byte.decode("");
      check(false, "No exception for Byte.decode(\"\")");
    } catch (NumberFormatException ex) { /* */ }
    if (BugFlags.NULL_DECODE) {
      try {
	Byte.decode(null);
	check(false, "No exception for Byte.decode(null)");
      } catch (NumberFormatException ex) { /* */ }
    }
    else {
      try {
	Byte.decode(null);
	check(false, "No exception for Byte.decode(null)");
      } catch (NullPointerException ex) { /* */ }
    }
    // Byte.decode(String) - Malformed values
    try {
      Byte.decode("#");
      check(false, "No exception for Byte.decode(\"#\")");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.decode("-");
      check(false, "No exception for Byte.decode(\"-\")");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.decode("0x");
      check(false, "No exception for Byte.decode(\"0x\")");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.decode(" 0");
      check(false, "No exception for Byte.decode(\" 0\")");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.decode("- 0");
      check(false, "No exception for Byte.decode(\"- 0\")");
    } catch (NumberFormatException ex) { /* */ }
    try {
      Byte.decode("-0 ");
      check(false, "No exception for Byte.decode(\"-0 \")");
    } catch (NumberFormatException ex) { /* */ }

    // Byte.hashCode()
    for (int i = 0; i < 256; i++) {
      check(new Byte((byte) i).byteValue() == (byte) i,
	    "Wrong value for Byte.hashCode()");
    }
        
  }    

  public String describe() {
    return "'Byte' wrapper class test";
  }
}
