package hitme.basic.types;

import hitme.BugFlags;

/**
 * Testing the 'Throwable' class
 */
public class ThrowableClass extends hitme.HitMeTest {

  public void test() 
  {
    String s = null;
    try {
      // Generate a null pointer exception
      s.equals("nothing");
    } catch (NullPointerException ex) {
      // ex.printStackTrace();
      StackTraceElement[] trace = ex.getStackTrace();
      check(trace.length == 5, "trace.length != 5");
      if (trace.length > 0) {
	StackTraceElement top = trace[0];
	check(top.getClassName().equals("hitme.basic.types.ThrowableClass"),
	      "className != ..ThrowableClass");
	check(top.getMethodName().equals("test"),
	      "methodName != test");
	check(top.getLineNumber() == 15, "lineNumber is wrong");	
	check(!top.isNativeMethod(), "method is native");
      }
    }
    try {
      // Generate a null pointer exception in another class
      "nothing".compareTo(s);
    } catch (NullPointerException ex) {
      // ex.printStackTrace();
      StackTraceElement[] trace = ex.getStackTrace();
      check(trace.length == 6, "trace.length != 6");
      if (trace.length > 0) {
	StackTraceElement top = trace[0];
	check(top.getClassName().equals("java.lang.String"),
	      "className != String");
	check(top.getMethodName().equals("compareTo"),
	      "methodName != compareTo");
	check(!top.isNativeMethod(), "method is native");
      }
      if (trace.length > 1) {
	StackTraceElement next = trace[1];
	check(next.getClassName().equals("hitme.basic.types.ThrowableClass"),
	      "className != ..ThrowableClass");
	check(next.getMethodName().equals("test"),
	      "methodName != test");
	check(next.getLineNumber() == 32, "lineNumber is wrong");
	check(!next.isNativeMethod(), "method is native");
      }
    }
    try {
      Class runtimeClass = Runtime.getRuntime().getClass();
      java.lang.reflect.Method nativeLoadMethod = 
	runtimeClass.getMethod("nativeLoad", new Class[]{"".getClass()});
      try {
	// Generate a null pointer exception in a native method
	Runtime.getRuntime().load(null);
      }
      catch (Throwable ex) {
	// ex.printStackTrace();
	StackTraceElement[] trace = ex.getStackTrace();
	check(trace.length == 6, "trace.length != 6");
      }
    } catch (NoSuchMethodException ex) {
      /* Runtime.nativeLoad is not native ... */
    }
  }

  public String describe() {
    return "'Throwable' class test";
  }
}
