package hitme.plava;

import plava.*;

/**
 * Testing the PStore class
 */
public class PStoreByteArray extends hitme.HitMeTest
{

  public String describe() {
    return "save / restore an byte[] as PStore root object";
  }
  
  public void test() {
    try {
      Object o = PStore.nativeGetRootObject();
      if (o == null) {
	PStore.nativeSetRootObject(new byte[]{1, 2, 3});
      }
      else {
        byte[] bytes = (byte[]) o;
	check(bytes.length == 3, "wrong size");
	check(bytes[0] == 1, "bytes[0] != 1");	
	check(bytes[1] == 2, "bytes[1] != 2");	
	check(bytes[2] == 3, "bytes[2] != 3");
      }
    }
    catch (StoreNotFoundException ex) {
      err(ex);
    }
  }
}
