package hitme.plava;

import plava.*;

/**
 * Testing the PStore class
 */
public class PStoreIntArray extends hitme.HitMeTest
{

  public String describe() {
    return "save / restore an int[] as PStore root object";
  }
  
  public void test() {
    try {
      Object o = PStore.nativeGetRootObject();
      if (o == null) {
	PStore.nativeSetRootObject(new int[]{1, 2, 3});
      }
      else {
        int[] ints = (int[]) o;
	check(ints.length == 3, "wrong size");
	check(ints[0] == 1, "ints[0] != 1");	
	check(ints[1] == 2, "ints[1] != 2");	
	check(ints[2] == 3, "ints[2] != 3");
      }
    }
    catch (StoreNotFoundException ex) {
      err(ex);
    }
  }

}
