package hitme.plava;

import plava.*;

/**
 * Testing the PStore class
 */
public class PStoreTree2 extends hitme.HitMeTest
{
  private int count;

  private class Node {
    public Node left;
    public Node right;
    public int value;
    public Node(Node left, Node right, int value) {
      this.left = left;
      this.right = right;
      this.value = value;
    }
  }

  public String describe() {
    return "save / restore a number of persistent trees";
  }
  
  public void test() {
    try {
      PStore store = PStore.getStoreRoot();
      Object tree = store.getRoot("tree-0");
      if (tree == null) {
	try {
	  for (int i = 0; i < 1000; i++) {
	    System.err.println("Iteration #" + i);
	    tree = createTree(i);
	    checkTree(tree, i);
	    store.addRoot("tree-" + i, tree);
	    store.stabiliseAll();
	  }
	}
	catch (OutOfMemoryError ex) {
	}
      }
      else {
	for (int i = 0; i < 1000; i++) {
	  System.err.println("Iteration #" + i);
	  tree = store.getRoot("tree-" + i);
	  if (tree == null) {
	    break;
	  }
	  checkTree(tree, i);
	}
      }
    }
    catch (StoreNotFoundException ex) {
      err(ex);
    }
  }

  private Node createTree(int depth) {
    count = 0;
    return createTree0(depth);
  }

  private Node createTree0(int depth) {
    if (depth <= 0) {
      return null;
    }
    else {
      return new Node(createTree0(depth - 1), createTree0(depth - 1), ++count);
    }
  }

  private void checkTree(Object tree, int depth) {
    count = 0;
    if (!checkTree0((Node) tree, depth)) {
      err("Tree check failed");
    }
  }

  private boolean checkTree0(Node tree, int depth) {
    if (depth <= 0) {
      return tree == null;
    }
    else {
      return (checkTree0(tree.left, depth - 1) &&
	      checkTree0(tree.right, depth - 1) &&
	      tree.value == ++count);
    }
  }
}
