package hitme.system;

import java.util.Properties;

/**
 * Test the contents of the System properties object.
 **/
public class SysProperties extends hitme.HitMeTest
{
  // The following are obtained by reading the respective JDK API
  // does for the System.getProperties() method.
  
  private static final String[] JDK_1_1_PROPS = new String[] {
    "java.version", "java.vendor", "java.vendor.url", "java.home",
    "java.class.version", "java.class.path", "os.name", "os.arch",
    "os.version", "file.separator", "path.separator", 
    "line.separator", "user.name", "user.home", "user.dir"
  };
  private static final String[] JDK_1_2_PROPS = new String[] {
    "java.version", "java.vendor", "java.vendor.url", "java.home",
    "java.vm.specification.version", "java.vm.specification.vendor", 
    "java.vm.specification.name", "java.vm.version", "java.vm.vendor", 
    "java.vm.name", "java.specification.version", 
    "java.specification.vendor", "java.specification.name", 
    "java.class.version", "java.class.path", "os.name", "os.arch",
    "os.version", "file.separator", "path.separator", 
    "line.separator", "user.name", "user.home", "user.dir"
  };
  private static final String[] JDK_1_3_PROPS = new String[] {
    "java.version", "java.vendor", "java.vendor.url", "java.home",
    "java.vm.specification.version", "java.vm.specification.vendor", 
    "java.vm.specification.name", "java.vm.version", "java.vm.vendor", 
    "java.vm.name", "java.specification.version", 
    "java.specification.vendor", "java.specification.name", 
    "java.class.version", "java.class.path", "java.ext.dirs", 
    "os.name", "os.arch", "os.version", "file.separator", 
    "path.separator", "line.separator", "user.name", "user.home", 
    "user.dir"
  };
  private static final String[] JDK_1_4_PROPS = new String[] {
    "java.version", "java.vendor", "java.vendor.url", "java.home",
    "java.vm.specification.version", "java.vm.specification.vendor", 
    "java.vm.specification.name", "java.vm.version", "java.vm.vendor", 
    "java.vm.name", "java.specification.version", 
    "java.specification.vendor", "java.specification.name", 
    "java.class.version", "java.class.path", "java.library.path",
    "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name",
    "os.arch", "os.version", "file.separator", "path.separator", 
    "line.separator", "user.name", "user.home", "user.dir"
  };
    
  public void test() 
  {
    Properties props = System.getProperties();

    String version = props.getProperty("java.version");
    check(version != null, "no 'java.version' property");

    String[] names =
      version.startsWith("1.1") ? JDK_1_1_PROPS :
      (version.startsWith("1.2") ? JDK_1_2_PROPS :
       (version.startsWith("1.3") ? JDK_1_3_PROPS :
	(version.startsWith("1.4") ? JDK_1_4_PROPS : null)));
    check(names != null, 
	  "unknown 'java.version' value: \"" + version + "\"");
    if (names != null) {
      testPropNames(props, names);
      // listProps(props, names); 
    }
  }

  public void testPropNames(Properties props, String[] names) 
  {
    for (int i = 0; i < names.length; i++) {
      String value = props.getProperty(names[i]);
      check(value != null, 
	    "Missing system property '" + names[i] + "'");
    }
  }

  public void listProps(Properties props, String[] names) 
  {
    for (int i = 0; i < names.length; i++) {
      String value = props.getProperty(names[i]);
      if (value != null) {
	logln(names[i] + ": " + value);
      }
    }
  }

  public String describe() 
  {
    return "Examining java.lang.System properties";
  }

}
