/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"
 
/* 
 * @doc MODULE 
 * @module Object.c | 
 * 
 * This file contains native methods for the VMObject class. 
 * 
 */ 
 
#include <stdio.h> 
 
#include "vm/interp.h" 
#include "vm/classfil.h" 
#include "vm/global.h" 
 
#include "vm/threadex.h" 
#include "vm/thread.h"
 
#include "vm/jni.h" 
#include "lib/indigenous/java.lang/Class.h" 
#include "vm/garbage.h" 

#include "vm/interp_methods.h"
#include "vm/newobject.h" 
#include "vm/locks.h"

#include "lib/indigenous/java.lang/Class.h"
#include "lib/indigenous/java.lang/Class_Reflection.h"

#include "lib/indigenous/java.lang/VMSystem.h"


extern tOBREF OOMExceptionObject;

/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: public final native void notify(); 
 * 
 * Notifies one of the threads in this object's wait set. 
 * 
 * @rdesc Returns one of: 
 * 
 * @flag 0 | Normal return 
 * @flag -1 | Return with exception thrown 
 * 
 */ 
 
void java_lang_VMObject_notify 
( 
  JNIEnv* env, 
  jobject obj_obj, 
  jobject obj 
) 
{ 
  jobject result  = (jobject) THREAD_NotifyRandom(env, obj); 
  if( ((int) result) == 0) 
  { 
    return ; 
  } 
  else 
  { 
    (*env)->Throw(env, result); 
  } 
 
} 
 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: public final native void notifyAll(); 
 * 
 * Notifies all of the threads in this object's wait set. 
 * 
 * @rdesc Returns one of: 
 * 
 * @flag 0 | Normal return 
 * @flag -1 | Return with exception thrown 
 * 
 */ 
 
void java_lang_VMObject_notifyAll 
( 
  JNIEnv* env, 
  jobject obj_obj, 
  jobject obj 
) 
{ 
 
  jobject result  = (jobject) THREAD_NotifyAll(env, obj); 
  if( ((int) result) == 0) 
  { 
    return ; 
  } 
  else 
  { 
    (*env)->Throw(env, result); 
  } 
 
} 
 
 
 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: public final native void wait(Long); 
 * 
 * Makes the current thread wait on this object. 
 * 
 * @rdesc Returns one of: 
 * 
 * @flag 0 | Normal return 
 * @flag -1 | Return with exception thrown 
 * 
 */ 
 
void java_lang_VMObject_wait 
( 
  JNIEnv* env, 
  jclass VMclass, 
  jobject obj, 
  jlong millis, 
  jint ns 
) 
{ 
     
  jobject result  = (jobject) THREAD_WaitOnObject(env, obj, millis); 
  if(result == NULL) 
  { 
    return ; 
  } 
  else 
  { 
    (*env)->Throw(env, result); 
  } 
} 
 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: protected static native Object clone(Object o); 
 * 
 * Clones this object. 
 * 
 * @rdesc Returns one of: 
 * 
 * @flag 0 | Normal return 
 * @flag -1 | Return with exception thrown 
 * 
 */ 
 
 

//this obj can be an array 

jobject java_lang_VMObject_clone 
( 
  JNIEnv* env, 
  jclass vmclazz, 
  jobject obj 
) 
{ 
  int i; 
  tClassLoaderTuple* pstClass; 
  tClassLoaderTuple* pstNewClass; 
  tOBREF pstNewObject; 
  jclass clazz;
  int failure;

  clazz = (*env)->GetObjectClass(env, obj);
  pstClass = CLASS_GetClassStruct(env,clazz); 
  
  if ((ODEREF(obj)->i32Flags & GARBAGE_TYPEMASK) == GARBAGE_ARRAY) {
    if ((ADEREF(obj)->enType == T_OBJECT) || 
	((ADEREF(obj)->enType == T_ARRAY))) {
      pstNewObject = (tOBREF) INTERP_NewArray(env, ADEREF(obj)->enType,
					      ADEREF(obj)->i32Number, 
					      pstClass->uidName + 1,
					      pstClass, &failure); //XXX Check this tuple
    }
    else {
      pstNewObject = (tOBREF) INTERP_NewArray(env, ADEREF(obj)->enType, 
					      ADEREF(obj)->i32Number, NULL, 
					      pstClass, &failure); //XXX Check this too
    }
    if (failure) {
      (*env)->Throw(env, pstNewObject);
      return NULL;
    }
    if (pstNewObject == NULL) {
      (*env)->Throw(env, OOMExceptionObject);
      return NULL;
    }
    //now copy the array
    Java_java_lang_VMSystem_arraycopy(env, clazz, (jarray) obj, 0,
				      (jarray) pstNewObject, 0, 
				      ADEREF(obj)->i32Number);
  }
  else {
    pstNewObject = INTERP_NewObject(env, pstClass, &failure); 
    if (failure) {
      (*env)->Throw(env, pstNewObject);
      return NULL;
    }
    if (pstNewObject == NULL) {
      (*env)->Throw(env, OOMExceptionObject);
      return NULL;
    }
    
    pstNewClass = DEREF(pstNewObject)->pstType; 
    
    if (pstNewClass->pstClass->u16InstSize) { 
      for (i = 0; 
	   i < DEREF(pstNewObject)->pstType->pstClass->u16InstSize; 
	   i++) {  
	DEREF(pstNewObject)->pi32Vars[i] = DEREF(obj)->pi32Vars[i]; 
      } 
    } 
  }
  return pstNewObject; 
} 
 
