/*
 * Copyright (C) 2001, John Leuner, Todd Miller.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"

#ifdef TEASEME

#include "vm/garbage.h"
#include "vm/newobject.h"
/*
  public native static byte  in8( short port );
  public native static char in16( short port );
  public native static int  in32( short port );
  
  public native static void  out8( short port, byte val );
  public native static void out16( short port, char val );
  public native static void out32( short port, int  val );
  
  public native static short read8(int address);
  public native static short write8(int address, short value); // Returns 8 bits written.
  public native static int read16(int address);
  public native static int write16(int address, int value); // Returns 16 bits written.
  public native static int read32(int address);
  public native static int write32(int address, int value); // Returns 32 bits written.
*/


#include "vm/jni.h"
#include "vm/global.h"

#include "lib/indigenous/jos.system/machine.h"

/* jos.system.machine */

jbyte jos_system_machine_in8(  JNIEnv* env, jclass clazz, short port)
{
  jbyte retval = 0;
#ifdef KISSME_LINUX_KERNEL
  retval = inb(port);
#else
  #ifndef MIPSEL
  asm("movw %0, %%dx" : : "m" (port)); // Move portnum into dx.
  asm("inb %dx, %al");		// Read port into al.
  asm("movb %%al, %0" : "=m" (retval)); // Move al's value into retval
  #endif
#endif
  return(retval);
}

jchar jos_system_machine_in16(  JNIEnv* env, jclass clazz, short port)
{
  jchar retval = 0;
#ifdef KISSME_LINUX_KERNEL
  retval = inw(port);
#else
  #ifndef MIPSEL
  asm("movw %0, %%dx" : : "m" (port)); // Move portnum into dx.
  asm("inw %dx, %ax");		// Read port into ax.
  asm("movw %%ax, %0" : "=m" (retval)); // Move ax's value into retval
  #endif
#endif
  return(retval);
}

jint jos_system_machine_in32(  JNIEnv* env, jclass clazz, short port)
{
  jint retval = 0;
#ifdef KISSME_LINUX_KERNEL
  retval = inl(port);
#else
  #ifndef MIPSEL
  asm("movl %0, %%edx" : : "m" (port)); // Move portnum into dx.
  asm("inl %dx, %eax");		// Read port into ax.
  asm("movl %%eax, %0" : "=m" (retval)); // Move eax's value into retval
  #endif					    
#endif
  return(retval);
}


void jos_system_machine_out8(  JNIEnv* env, jclass clazz, short port, jbyte value)
{
#ifdef KISSME_LINUX_KERNEL
  outb(value, port);
#else
   #ifndef MIPSEL
  asm("movw %0, %%dx" : : "m" (port));
  asm("movb %0, %%al" : : "m" (value));
  asm("outb %al, %dx");
 #endif
#endif
}

void jos_system_machine_out16(  JNIEnv* env, jclass clazz, short port, jchar value)
{
#ifdef KISSME_LINUX_KERNEL
  outw(value, port);
#else
  #ifndef MIPSEL
 asm("movw %0, %%dx" : : "m" (port));
 asm("movw %0, %%ax" : : "m" (value));
 asm("outw %ax, %dx");
 #endif
#endif
}

void jos_system_machine_out32(  JNIEnv* env, jclass clazz, short port, jint value)
{
#ifdef KISSME_LINUX_KERNEL
  outl(value, port);
#else
  #ifndef MIPSEL
  asm("movw %0, %%dx" : : "m" (port));
  asm("movl %0, %%eax" : : "m" (value));
  asm("outl %eax, %dx");
  #endif
#endif
}

jchar jos_system_machine_read8(  JNIEnv* env, jclass clazz, jint address)
{
  //Strip upper 32 bits of address
  //Return the first 8 bits at that address
#ifdef KISSME_LINUX_KERNEL
  return readb(address);
#else
  return * ((int8*) (address));
#endif
}

int16 jos_system_machine_write8(  JNIEnv* env,jclass clazz,  jint address, jchar value)
{
#ifdef KISSME_LINUX_KERNEL
  writeb(value, address);
  return value;
#else
  //Strip upper 32 bits of address
  //Write the first 8 bits at that address
  * (int8*) (address) = (int8) value;
  return (int16) value;
#endif
}

jint jos_system_machine_read16(  JNIEnv* env, jclass clazz, jint address)
{
#ifdef KISSME_LINUX_KERNEL
  return readw(address);
#else
  return * (int16*) (address);
#endif
}

jint jos_system_machine_write16(  JNIEnv* env, jclass clazz, jint address, jint value)
{
#ifdef KISSME_LINUX_KERNEL
  writew(value, address);
  return value;
#else
  //Strip upper 32 bits of address
  //Write the first 8 bits at that address
  * (int16*) (address) = (int16) value;
  return  value;
#endif
}

jint jos_system_machine_read32(  JNIEnv* env, jclass clazz, jint address)
{
#ifdef KISSME_LINUX_KERNEL
  return readl(address);
#else
  return * ((int32*) (address));
#endif
}

jint jos_system_machine_write32(  JNIEnv* env,jclass clazz,  jint address, jint value)
{
#ifdef KISSME_LINUX_KERNEL
  writel(value, address);
  return value;
#else
  int32 *ptr;
  ptr = (int32*) address;
  * ptr = (int32) value;
  return value;
#endif
}
/*
    public native static short write8(int address, short value); // Returns 8 bits written.
    public native static int read16(int address);
    public native static int write16(int address, int value); // Returns 16 bits written.
    public native static int read32(int address);
    public native static int write32(int address, int value); // Returns 32 bits written.
*/
//#endif

tMutex* print_lock = NULL;

void jos_system_machine_printk(JNIEnv* env, jclass class, jstring str)
{
  char* pszString;
  //  jboolean isCopy = JNI_FALSE;

  if(print_lock == NULL)
    print_lock = sys_mutex_create(0);

  if(str != NULL)
    {
      sys_mutex_lock(print_lock);
      pszString = INTERP_AscizFromString(env, str);
      eprintf("%s", pszString);
      sys_free(pszString);
      sys_mutex_unlock(print_lock);
    }
}

//extern volatile int iSystemHeapDestroyed;

void jos_system_machine_freeSystemHeap(JNIEnv* env, jclass clazz)
{
//  GARBAGE_Finish( (*env)->getHeap());
//  iSystemHeapDestroyed = 1;
}

#endif
