#! /bin/sh
# usage: merge <kissme-packages> <gnu-packages> 
#              <kissme-excludes> <gnu-excludes>
# Merge Java source code and other necessary files from the Kissme
# classes tree and the GNU Classpath tree.  The parameters are as
# follows:
# 
# <kissme-packages> is a list space separated list of java packages /
#                   package trees to be merged from the Kissme tree
# <gnu-packages>    ditto, except from the GNU Classpath tree
# <kissme-excludes> is a list of file containing regex patterns for files
#                   to be excluded from the Kissme fileset
# <gnu-excludes>    ditto, except from the GNU Classpath fileset
#

KISSME=/home/jewel/dev/kissmecvs
GNU_CLASSPATH=/home/jewel/dev/classpath
KISSME_PACKAGES=${1:-"gnu jos plava java teaseme kissme/vm"}
GNU_PACKAGES=${2:-"java javax gnu"}
KISSME_EXCLUDES=${3:-/dev/null}
GNU_EXCLUDES=${4:-${GNU_CLASSPATH_DIR}/lib/standard.omit}
KCP_DIR=

echo "+++ Building kissme-classpath.tar in /tmp"
cd $GNU_CLASSPATH

tar --create --file /tmp/kissme-classpath.tar README

# The *.omit list contains regex patterns relative to qlib
# but tar requires shell-style filename patterns relative to lib/..

echo "--- creating GNU exclusion list from ${GNU_EXCLUDES}"
cat ${GNU_EXCLUDES} | sed -e s:\\.\\./::g > /tmp/exclude-x-gnu
find . -print  | \
    grep -f /tmp/exclude-x-gnu | \
    sed -e s:\\./::g > /tmp/exclude-gnu

echo "--- adding GNU packages from $GNU_CLASSPATH"
for d in $GNU_PACKAGES ; do
  echo -n "$d "
  find $d -name \*.java -print > /tmp/list
  tar --append --file /tmp/kissme-classpath.tar \
      --exclude-from=/tmp/exclude-gnu --files-from=/tmp/list
done
echo

echo "--- adding GNU locale properties, unicode tables and other resources"
tar --append --file /tmp/kissme-classpath.tar \
    `find gnu/java/locale -name '*.properties'`

# FIXME need to be more selective ... 
tar --append --file /tmp/kissme-classpath.tar \
    `find resource -name '*.properties' -o -name '*.security'`

cd $KISSME/classes

echo "--- creating Kissme exclusion list from ${KISSME_EXCLUDES}"
cat ${KISSME_EXCLUDES} | sed -e s:\\.\\./::g > /tmp/exclude-x-kissme
find . -print  | \
    grep -f /tmp/exclude-x-kissme | \
    sed -e s:\\./::g > /tmp/exclude-kissme


echo "--- adding KISSME packages from $KISSME/classes"
for i in ${KISSME_PACKAGES} ; do
  echo -n "$i "
  tar --append --file /tmp/kissme-classpath.tar \
    --exclude-from=/tmp/exclude-kissme `find $i -name '*.java'`
done
echo

echo "--- finished building kissme-classpath.tar"

echo "+++ Clearing out $KCP_DIR"
cd $KCP_DIR
rm -rf *

echo "+++ Extracting kissme-classpath.tar into $KCP_DIR"
tar --extract --file /tmp/kissme-classpath.tar

echo "+++ Kissme Classpath merge done"




