#ifndef __CLASSFILE_INTERNAL_H__
#define __CLASSFILE_INTERNAL_H__

#define locgetu1()             memgetu1(pbArray, pi32ArrayPos)
#define locgetu2()             memgetu2(pbArray, pi32ArrayPos)
#define locgetu4()             memgetu4(pbArray, pi32ArrayPos)
#define locgetu8()	       memgetu8(pbArray, pi32ArrayPos)
#define locgetpos()            (*pi32ArrayPos)
#define locgetpb()             (&((pbArray)[*pi32ArrayPos]))
#define locskip(i32Amount)     (*pi32ArrayPos += (i32Amount))
#define locsetpos(i32Amount)   (*pi32ArrayPos = (i32Amount))

#define getu1()             memgetu1(pbArray, &i32ArrayPos)
#define getu2()             memgetu2(pbArray, &i32ArrayPos)
#define getu4()             memgetu4(pbArray, &i32ArrayPos)
#define getpos()            (i32ArrayPos)
#define getpb()             (&((pbArray)[i32ArrayPos]))
#define skip(i32Amount)     (i32ArrayPos += (i32Amount))
#define setpos(i32Amount)   (i32ArrayPos = (i32Amount))


/*
 * @doc TYPE
 * @struct
 * Structure to store information about a class's fields.  This struture is
 * used for temporary storage before the information is copied into a tField
 * structure inside the tClass structure.
 *
 */

struct tfieldinfo
{
  uint16 u16AccessFlags;       /* @field Access flags */
  Uid uidName;                 /* @field Field name */
  Uid uidSignature;            /* @field Signature */
  uint16 u16ConstValueIndex;   /* @field This will be non-0 if the field has a
                                   constant value attribute, 0 otherwise. */
};

/*
 * @doc TYPE
 * @type tFieldInfo | typedef of tfieldinfo struct
 */

typedef struct tfieldinfo tFieldInfo;

#endif
