/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"

#ifndef DADDY_IS_WATCHING
#error Bad boy!
#endif

#include "vm/classfil.h"

/* function prototypes *****************************************************/
int CLASSFILE_Init();

#include "vm/classloader_tuple.h"

tClassLoaderTuple* CLASSFILE_ClassCreate(JNIEnv* env, byte* pbData,
					 char* className, jobject classLoader,
					 uint32* errorCode);
tClassLoaderTuple* CLASSFILE_ArrayClassCreate(JNIEnv* env, char* className,
					      tClassLoaderTuple* baseType);

void CLASSFILE_CompleteClass(JNIEnv* env, tClassLoaderTuple* pstClass);

tObject** CLASSFILE_InitClass(JNIEnv* env, tClassLoaderTuple* pstClass);

tClassLoaderTuple* CLASSFILE_NewTuple(JNIEnv* env, char* pszName,  
				      jobject classLoader);

tField* CLASSFILE_InstFieldOffset(JNIEnv* env, tClassLoaderTuple* Class, 
				  char* pszFieldname);
tField* CLASSFILE_StatFieldOffset(JNIEnv* env, tClassLoaderTuple* Class, 
				  char* pszFieldname);
tField* CLASSFILE_UidInstFieldOffset(JNIEnv* env, tClassLoaderTuple* Class,
				     Uid uidFieldname);
tField* CLASSFILE_UidStatFieldOffset(JNIEnv* env, tClassLoaderTuple* Class,
				     Uid uidFieldname);

tMethod* CLASSFILE_FindMethod(JNIEnv* env, tClassLoaderTuple *c, char* pszName,
			      char* pszSignature);
tMethod* CLASSFILE_FindMethodInVT(JNIEnv* env, tClassLoaderTuple* pstClass,
				  char* pszName, char* pszSignature);
tMethod* CLASSFILE_UidFindMethodInVT(JNIEnv* env, tClassLoaderTuple* pstClass,
				     Uid uidName, Uid uidSignature);
tMethod* CLASSFILE_UidFindMethod(JNIEnv* env, tClassLoaderTuple *c, 
				 Uid uidName, Uid uidSignature);
uint16 CLASSFILE_ParseArgumentLength(char *signature, int is_static);
uint16 CLASSFILE_CalcNumArguments(char* pszSignature);
uint16 CLASSFILE_GetArgumentType(char* pszSignature, int index);
uint16 CLASSFILE_GetReturnType(char* pszSignature);
uint16 CLASSFILE_ParseReturnLength(const char *signature);
int CLASSFILE_NativeInstOffset(JNIEnv* env, tClassLoaderTuple*, 
			       Uid uidClassName, Uid uidFieldName);
int CLASSFILE_NativeStatOffset(JNIEnv* env, tClassLoaderTuple*, 
			       Uid uidClassName, Uid uidFieldName);
int CLASSFILE_NativeInstOffsetPtr(JNIEnv* env, tClassLoaderTuple*,
				  Uid uidFieldName);
int CLASSFILE_NativeStatOffsetPtr(JNIEnv* env, tClassLoaderTuple*,
				  Uid uidFieldName);

/* function prototypes for the constant pool resolution functions */
void CLASSFILE_ResolveReferences(void);
tClassLoaderTuple* CLASSFILE_ResolveClass(JNIEnv* env, tClassLoaderTuple*, 
					  uint16);
tField* CLASSFILE_ResolveFieldref(JNIEnv* env, tClassLoaderTuple*, 
				  uint16, int);
tMethod* CLASSFILE_ResolveMethodref(JNIEnv* env, tClassLoaderTuple*,
				    uint16, int);
tMethod* CLASSFILE_ResolveMethodrefStatic(JNIEnv* env, tClassLoaderTuple*, 
					  uint16);
tMethod* CLASSFILE_ResolveMethodrefInterface(JNIEnv* env, tClassLoaderTuple*,
					     uint16, int32*, uint16);

int CLASSFILE_ResolveMethodExceptions(JNIEnv* env, tMethod* method);


#ifdef OLD_RESOLVE
/* these check to see whether or not the item is resolved, resolving it if
   it is not and just returning it if it is */
#define CONSTGET_Class(e, c, i) \
  (((c)->pbConstTags[(i)] & CONSTANT_ResolvedFlag) ? \
   (tClassLoaderTuple*) (c)->pu32ConstPool[(i)] : \
   CLASSFILE_ResolveClass((e), (c), (i)))
#define CONSTGET_MethodNonVirtual(e, c, i) \
  (((c)->pbConstTags[(i)] & CONSTANT_ResolvedFlag) ? \
   (tMethod*) (c)->pu32ConstPool[(i)] : \
   CLASSFILE_ResolveMethodref((e), (c), (i), 0))
#define CONSTGET_MethodVirtual(e, c, i, t) \
  (((c)->pbConstTags[(i)] & CONSTANT_ResolvedFlag) ? \
   (tMethod*) (c)->pu32ConstPool[(i)] : \
   CLASSFILE_ResolveMethodref((e), (c), (i), 1))
#else
tClassLoaderTuple* CONSTGET_Class(JNIEnv* env, tClassLoaderTuple* tuple, 
				  uint16 i);
#define CONSTGET_MethodNonVirtual(e, c, i) \
  CLASSFILE_ResolveMethodref((e), (c), (i), 0)
#define CONSTGET_MethodVirtual(e, c, i) \
  CLASSFILE_ResolveMethodref((e), (c), (i), 1)
#endif


#define CONSTGET_StatField(e, c, i) \
  (((c->pstClass)->pbConstTags[(i)] & CONSTANT_ResolvedFlag) ? \
   ((tField*) (c->pstClass)->pu32ConstPool[(i)]) : \
    CLASSFILE_ResolveFieldref((e), (c), (i), 1))

#define CONSTGET_Field(e, c, i) \
  (((c->pstClass)->pbConstTags[(i)] & CONSTANT_ResolvedFlag) ? \
   ((tField*) (c->pstClass)->pu32ConstPool[(i)]) : \
   CLASSFILE_ResolveFieldref((e), (c), (i), 0))

#define CONSTGET_UidFieldSig(e, c, i) \
  (((c->pstClass)->pbConstTags[(i)] & CONSTANT_ResolvedFlag) ? \
   ((tField*) (c->pstClass)->pu32ConstPool[(i)])->uidFieldSig : \
   CLASSFILE_ResolveFieldref((e), (c), (i), 0)->uidFieldSig)

#define CONSTGET_InstFieldOffset(e, c, i) \
  (((c->pstClass)->pbConstTags[(i)] & CONSTANT_ResolvedFlag) ? \
   ((tField*) (c->pstClass)->pu32ConstPool[(i)])->u16Offset : \
   CLASSFILE_ResolveFieldref((e), (c), (i), 2)->u16Offset)

#define CONSTGET_StatFieldOffset(e,c, i) \
  (((c->pstClass)->pbConstTags[(i)] & CONSTANT_ResolvedFlag) ? \
   ((tField*) (c->pstClass)->pu32ConstPool[(i)])->u16Offset : \
   CLASSFILE_ResolveFieldref((e), (c), (i), 1)->u16Offset)

#define CONSTGET_MethodStatic(e, c, i) \
  (((c->pstClass)->pbConstTags[(i)] & CONSTANT_ResolvedFlag) ? \
   (tMethod*) (c->pstClass)->pu32ConstPool[(i)] : \
   CLASSFILE_ResolveMethodref((e), (c), (i), 0))

/* this will always do a search */
#define CONSTGET_MethodInterface(e, c, i, o, l) \
  (((c->pstClass)->pbConstTags[(i)] & CONSTANT_ResolvedFlag) ? \
   (tMethod*) (c->pstClass)->pu32ConstPool[(i)] : \
   CLASSFILE_ResolveMethodrefInterface((e), (c), (i), (o), (l)))

/* this returns the item in its raw state, used when it's already resolved */
#define CONSTGET(c, i) ((c)->pu32ConstPool[(i)])

#define CONSTGET_UidAsciz(c, i) ((Uid) (c)->pu32ConstPool[(i)])
#define CONSTGET_Unicode(c, i) ((uint16*) (c)->pu32ConstPool[(i)])

#define CONSTGET_Int(c, i) ((uint32) (c)->pu32ConstPool[(i)])
#define CONSTGET_Float(c, i) (((float*) (c)->pu32ConstPool)[(i)])

#define CONSTGET_Double_High(c, i) ((uint32) (c)->pu32ConstPool[(i)])
#define CONSTGET_Double_Low(c, i) ((uint32) (c)->pu32ConstPool[(i) + 1])

#define CONSTGET_String_Index(c, i) ((uint16) (c)->pu32ConstPool[(i)])

#define CONSTSET(c, i, v) ((c)->pu32ConstPool[(i)] = ((uint32) (v)))

/* we have to filter out the resolved flag */
#define CONSTTAG(c, i) ((c)->pbConstTags[(i)] & CONSTANT_TypeMask)

/* for manually getting the resolved flag */
#define CONSTTAG_GetRes(c, i) ((c)->pbConstTags[(i)] & CONSTANT_ResolvedFlag)

/* for manually setting the resolved flag */
#define CONSTTAG_SetRes(c, i) ((c)->pbConstTags[(i)] |= CONSTANT_ResolvedFlag)

typedef struct tclasspath {
  char** ppszClassPaths;
  uint16 u16NumClassPaths;
} tClassPath;

extern tClassPath CLASSFILE_BootClassPath;
extern tClassPath CLASSFILE_UserClassPath;

uint16 CLASSFILE_CalcNumArguments(char* pszSignature);
int CLASSFILE_CanFindClass(char*);

byte* CLASSFILE_getClassStructHeap();
int CLASSFILE_getBytesUsedForClassHeaders();


tClassLoaderTuple* CLASSFILE_LoadAndLink(JNIEnv* env, char* pszClassName, 
					 uint32* errorCode,
					 tClassLoaderTuple* loadingClass);

tClassLoaderTuple* CLASSFILE_LoadAndLinkArray(JNIEnv* env, char* pszClassName,
					      uint32* errorCode, 
					      tClassLoaderTuple* loadingClass);

//not finished
//int CLASSFILE_FullyResolveClass(JNIEnv* env, tClassLoaderTuple* tuple  /* @parm Class whose constant pool we want to resolve */);

int CLASSFILE_IsArgumentRef(char* pszSignature, int index, int* slotOffset);

void CLASSFILE_ConsolidateClass(tClassLoaderTuple* pstClass,
				tClassLoaderTuple* pstNewClass,
				int32* pi32ClassSize);
/* end of classfile_methods.h */
