#include "eta.h"

/*
  Gamma is an interface to what the virtual machine sees as secondary storage (the store).

  The virtual machine knows nothing about the fact that the pages are cached in memory, distributed over multiple machines etc. It only sees the storage as a large linear range of bytes.

  Gamma provides the following methods:

int GAMMA_write(long long address, void* buf, long long offset, int buf_len);
int GAMMA_read(long long address, void* buf, long long offset, int buf_len);
int GAMMA_flush(long long address_start, long long address_end);

The read/write methods take a 64 bit address (it must always be a multiple of 2^12), a pointer to a memory buffer, a 64 bit offset and the length of data to read/write.

The offset allows data to be read/written at a position between 0 and 2^12 bytes into the array.

An additional method, GAMMA_flush, takes a starting and ending 64 bit address. GAMMA_flush instructs the secondary storage to make sure that all pages within this range get written to secondary storage. 

The actual implementation of these methods is discussed in gamma.c
*/


int GAMMA_write(long long address, void* buf, long long offset, int buf_len);
int GAMMA_read(long long address, void* buf, long long offset, int buf_len);
int GAMMA_flush(long long start_address, long long end_address);

/* This structure is used to keep a list of pages that have changed since they were last written to the Virtual Disk Server */

struct dirty_page_entry {
  int magic; //Just for debugging, to detect pointer errors
  struct page_entry* stpePage; //The actual page that is dirty (see eta.h)
  struct dirty_page_entry* next;//next and previous pointers
  struct dirty_page_entry* prev;
};



