#ifndef __VMGLOBAL_H__
#define __VMGLOBAL_H__

/*#include "target.h"*/

#ifdef TIMING
void GLOBAL_StartPrintTime(char* mesg);
void GLOBAL_PrintTime(char* mesg);
#endif

#ifdef TRACK_MALLOC
#include <stdlib.h>
void TRACK_Init(char* filename);
void TRACK_Finish(void);
void* TRACK_Malloc(size_t size, char file[], int linenum);
void TRACK_Free(void* ptr, char file[], int linenum);
void* TRACK_Realloc(void* ptr, size_t size, char file[], int linenum);
#define malloc(x) TRACK_Malloc((x), __FILE__, __LINE__)
#define free(x) TRACK_Free((x), __FILE__, __LINE__)
#define realloc(x, y) TRACK_Realloc((x), (y), __FILE__, __LINE__)
#else /* TRACK_MALLOC */


#ifdef USE_GW_HEAP
#include "heap.h"
/*#include "eglheap.h"
  #define malloc(x) EGL_Malloc(x)
  #define calloc(n,x) EGL_Calloc(n.x)
  #define free(x) EGL_Free(x)
  #define realloc(p,x) EGL_Realloc(p,x)
  #define strdup(s) EGL_StrDup(s)*/
#ifdef USE_GW_DEBUG
#include "gwdebug.h"
#endif /*USE_GW_DEBUG*/
#else
#include <stdlib.h>
#endif /*USE_GW_HEAP*/

#ifdef DECODER_CODE

#define malloc(x) POOL_malloc ((x))
#define free(x) POOL_free ((x))

void *POOL_malloc(size_t);
void POOL_free(void*);

#endif

#ifdef NON_PC_TARGET

#define malloc(x) EGL_Malloc(x)
#define free(x) EGL_Free(x)
#define realloc(p,x) EGL_Realloc(p,x)
#endif 

#endif /* TRACK_MALLOC */

#endif
