
/* 
 * This header file is included directly into loop.c, it handles all
 * the constant instructions which push one or two items onto the
 * stack 
 */

#ifdef not_def
{
  {
    {
#endif
    case iconst_0:
    case aconst_null:
      {
        *(++optop) = 0;
        break;
      }
      
    case iconst_m1:
      {
        *(++optop) = -1;
        break;
      }
      
    case iconst_1:
      {
        *(++optop) = 1;
        break;
      }
      
    case iconst_2:
      {
        *(++optop) = 2;
        break;
      }
      
    case iconst_3:
      {
        *(++optop) = 3;
        break;
      }
      
    case iconst_4:
      {
        *(++optop) = 4;
        break;
      }
      
    case iconst_5:
      {
        *(++optop) = 5;
        break;
      }
      
    case lconst_0:
      {
        *(++optop) = 0;
        *(++optop) = 0;
        break;
      }
      
    case lconst_1:
      {
	optop += 2;
	*((long long*) (optop - 1)) = 1;
        break;
      }
      
      /* Interesting way of getting the float on the stack! */
    case fconst_0:
      {
	union {float f; int32 i;} ui32fConv1;
	ui32fConv1.f = 0;
	*(++optop) = ui32fConv1.i;
	break;
      }

    case fconst_1:
      {
	union {float f; int32 i;} ui32fConv1;
	ui32fConv1.f = 1;
	*(++optop) = ui32fConv1.i;
	break; 
      }
      
    case fconst_2:
      {
	union {float f; int32 i;} ui32fConv1;
	ui32fConv1.f = 2;
	*(++optop) = ui32fConv1.i;
	break;
      }
      
    case dconst_0:
      {
	optop += 2;
	*((double*) (optop - 1)) = 0;
	break;
      }
      
    case dconst_1:
      {
	optop += 2;
	*((double*) (optop - 1)) = 1;
	break;
      }
