/* 
 * This header file is included directly into interp_loop.c 
 *
 * It handles all the instructions for loading and storing variables,
 * also for array variables 
 */

#ifdef not_def
{
  {
    {
#endif
    case iload:
      {
        *(++optop) = pi32Vars[(*pbPC++)];
        break;
      }

    case lload:
      {
        *(++optop) = pi32Vars[*pbPC];
        *(++optop) = pi32Vars[(*pbPC++) + 1];
        break;
      }
      
    case fload:
      {
        *(++optop) = pi32Vars[(*pbPC++)];
        break;
      }
      
    case dload:
      {
        *(++optop) = pi32Vars[*pbPC];
	*(++optop) = pi32Vars[(*pbPC++) + 1];
        break;
      }
      
    case aload:
      {
        *(++optop) = pi32Vars[(*pbPC++)];
        break;
      }
      
    case iload_0:
      {
        *(++optop) = pi32Vars[0];
        break;
      }
      
    case iload_1:
      {
        *(++optop) = pi32Vars[1];
        break;
      }
      
    case iload_2:
      {
        *(++optop) = pi32Vars[2];
        break;
      }
      
    case iload_3:
      {
        *(++optop) = pi32Vars[3];
        break;
      }
      
    case lload_0:
      {
	*(++optop) = pi32Vars[0];
	*(++optop) = pi32Vars[1];
        break;
      }
      
    case lload_1:
      {
        *(++optop) = pi32Vars[1];
        *(++optop) = pi32Vars[2];
        break;
      }
      
    case lload_2:
      {
        *(++optop) = pi32Vars[2];
        *(++optop) = pi32Vars[3];
        break;
      }
      
    case lload_3:
      {
        *(++optop) = pi32Vars[3];
        *(++optop) = pi32Vars[4];
        break;
      }
      
    case fload_0:
      {
        *(++optop) = pi32Vars[0];
        break;
      }
      
    case fload_1:
      {
        *(++optop) = pi32Vars[1];
        break;
      }
    
    case fload_2:
      {
        *(++optop) = pi32Vars[2];
        break;
      }
      
    case fload_3:
      {
        *(++optop) = pi32Vars[3];
        break;
      }
    
    case dload_0:
      {
        *(++optop) = pi32Vars[0];
        *(++optop) = pi32Vars[1];
        break;
      }
      
    case dload_1:
      {
        *(++optop) = pi32Vars[1];
        *(++optop) = pi32Vars[2];
        break;
      }
      
    case dload_2:
      {
        *(++optop) = pi32Vars[2];
        *(++optop) = pi32Vars[3];
        break;
      }
      
    case dload_3:
      {
	*(++optop) = pi32Vars[3];
	*(++optop) = pi32Vars[4];
	break;
      }
      
    case aload_0:
      {
	*(++optop) = pi32Vars[0];
	break;
      }
      
    case aload_1:
      {
	*(++optop) = pi32Vars[1];
	break;
      }
      
    case aload_2:
      {
	*(++optop) = pi32Vars[2];
	break;
      }
   
    case aload_3:
      {
	*(++optop) = pi32Vars[3];
	break;
      }
      
    case iaload:
      {
	optop--;
	if (*optop) {
	  if ((*(optop + 1) < ADEREF((tARREF) *optop)->i32Number) &&
	      (*(optop + 1) >= 0)) {
	    *optop = 
	      ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
	  }
	  else {
	    SAVEENV();
	    pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, 
					   (int32) *(optop + 1));
	    LOADENV();
	  }
	}
	else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	}
	break;
      }
      
    case laload:
      {
	long long*  pi64Temp;
	int32 i32Index;
	
	if (*(optop - 1)) {
	  if (*optop < ADEREF((tARREF) *(optop - 1))->i32Number &&
	      (*(optop) >= 0)) {
	    pi64Temp = (long long*) ADEREF((tARREF) *(optop - 1))->pvElements;
	    i32Index = *optop;
	    *((long long*) (optop - 1)) = pi64Temp[i32Index];
	  }
	  else {
	    SAVEENV();
	    pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, (int32)(*optop));
	    LOADENV();
	  }
	}
	else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	}
        break;
      }
      
    case faload:
      {
        optop--;
        if (*optop) {
          if (*(optop + 1) < ADEREF((tARREF) *optop)->i32Number && 
	      (*(optop + 1) >= 0)) {
	    *optop = 
	      ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
	  }
          else {
            SAVEENV();
            pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, 
					   (int32)(*(optop + 1)));
            LOADENV();
          }
        }
	else {
          SAVEENV();
          pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
          LOADENV();
        }
        break;
      }

    case daload:
      {
	int32*  pi32Temp;
	
	if (*(optop - 1)) {
	  if (*optop < ADEREF((tARREF) *(optop - 1))->i32Number &&
	      (*(optop) >= 0)) {
	    pi32Temp = ADEREF((tARREF) *(optop - 1))->pvElements;
	    *(optop - 1) = pi32Temp[(*optop) * 2];
	    *optop = pi32Temp[(*optop) * 2 + 1];
	  }
	  else {
	    SAVEENV();
	    pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, (int32)(*optop));
	    LOADENV();
	  }
	}
        else {
          SAVEENV();
          pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
          LOADENV();
        }
        break;
      }

      case aaload:
      {
        optop--;

        if (*optop) {
          if ((*(optop + 1) < ADEREF((tARREF) *optop)->i32Number) && 
	      (*(optop + 1) >= 0)) {
#ifdef PERSIST
            /* check if the element is a PID */
#ifdef EAGERINDIRECT
            /* assume that it's already swizzled */
            *optop = 
	      ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
#else

#ifndef GARBAGE_GENERATIONAL
            /* check if it's swizzled */
	    
            if (ISPID((PID) ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)]))
            {
#ifdef NOSWIZZLE
              *optop = 
		(int32) RPOT_FaultObject(((int32*) (ADEREF((tARREF) *optop)->pvElements))[*(optop + 1)]);
#else
              ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)] =
		(int32) RPOT_FaultObject(((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)]);
              *optop =
		((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
#endif
            }
            else {
#endif
              *optop = 
		((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
#ifndef GARBAGE_GENERATIONAL
            }
#endif
#endif /* eagerindirect */
#else
            *optop = 
	      ((int32*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
#endif /* persist */
          }
          else {
            SAVEENV();
            pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, 
					   (int32) *(optop + 1));
            LOADENV();
          }
	}
	else {
          SAVEENV();
          pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
          LOADENV();
        }
        break;
      }
      
    case baload:
      {
        optop--;
        if (*optop) {
          if ((*(optop + 1) < ADEREF((tARREF) *optop)->i32Number) &&
	      (*(optop + 1) >= 0)) {
	    //No sign extension or any shit like that?
            *optop = 
	      ((byte*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
	    
	    if (*optop & 0x80) {
	      *optop = -(256 - *optop);
	    }
          }
          else {
            SAVEENV();
            pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, 
					   (int32) *(optop + 1));
            LOADENV();
          }
        }
        else {
          SAVEENV();
          pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
          LOADENV();
        }
        break;
      }
      
    case caload:
      {
        optop--;
        if (*optop) {
	 if (*(optop + 1) < ADEREF((tARREF) *optop)->i32Number &&
	     (*(optop + 1) >= 0)) {
	   *optop =
	     ((uint16*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
	 }
	 else {
	   SAVEENV();
	   pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, 
					  (int32) *(optop + 1));
	   LOADENV();
	 }
	}
        else {
          SAVEENV();
          pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
          LOADENV();
        }
        break;
      }
      
    case saload:
      {
        optop--;
        if (*optop) {
          if ((*(optop + 1) >= 0) && 
	      (*(optop + 1) < ADEREF((tARREF) *optop)->i32Number)) {
            *optop =
	      ((int16*) ADEREF((tARREF) *optop)->pvElements)[*(optop + 1)];
          }
          else {
	    SAVEENV();
	    pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, 
					   (int32) *(optop + 1));
	    LOADENV();
          }
        }
        else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
        }
        break;
      }
      
    case istore:
      {
        pi32Vars[(*pbPC++)] = *(optop--);
        break;
      }
      
    case astore:
      {
        pi32Vars[(*pbPC++)] = *(optop--);
        break;
      }
      
    case lstore:
      {
        pi32Vars[(*pbPC) + 1] = *(optop--);
        pi32Vars[(*pbPC++)] = *(optop--);
        break;
      }
      
    case fstore:
      {
        pi32Vars[(*pbPC++)] = *(optop--);
        break;
      }
      
    case dstore:
      {
        pi32Vars[(*pbPC) + 1] = *(optop--);
        pi32Vars[(*pbPC++)] = *(optop--);
        break;
      }

    case istore_0:
      {
        pi32Vars[0] = *(optop--);
        break;
      }
     
    case istore_1:
      {
        pi32Vars[1] = *(optop--);
        break;
      }
    
    case istore_2:
      {
        pi32Vars[2] = *(optop--);
        break;
      }
    
    case istore_3:
      {
        pi32Vars[3] = *(optop--);
        break;
      }
    
    case lstore_0:
      {
        pi32Vars[1] = *(optop--);
        pi32Vars[0] = *(optop--);
        break;
      }
	
    case lstore_1:
      {
        pi32Vars[2] = *(optop--);
        pi32Vars[1] = *(optop--);
	break;
      }
      
    case lstore_2:
      {
        pi32Vars[3] = *(optop--);
        pi32Vars[2] = *(optop--);
        break;
      }
      
    case lstore_3:
      {
        pi32Vars[4] = *(optop--);
        pi32Vars[3] = *(optop--);
        break;
      }
      
    case fstore_0:
      {
        pi32Vars[0] = *(optop--);
        break;
      }
      
    case fstore_1:
      {
        pi32Vars[1] = *(optop--);
        break;
      }
      
    case fstore_2:
      {
        pi32Vars[2] = *(optop--);
        break;
      }

    case fstore_3:
      {
	pi32Vars[3] = *(optop--);
        break;
      }
      
    case dstore_0:
      {
	pi32Vars[1] = *(optop--);
        pi32Vars[0] = *(optop--);
        break;
      }
      
    case dstore_1:
      {
        pi32Vars[2] = *(optop--);
        pi32Vars[1] = *(optop--);
        break;
      }
      
    case dstore_2:
      {
        pi32Vars[3] = *(optop--);
        pi32Vars[2] = *(optop--);
        break;
      }
      
    case dstore_3:
      {
        pi32Vars[4] = *(optop--);
        pi32Vars[3] = *(optop--);
        break;
      }
      
    case astore_0:
      {
        pi32Vars[0] = *(optop--);
	break;
      }
      
    case astore_1:
      {
        pi32Vars[1] = *(optop--);
        break;
      }
      
    case astore_2:
      {
        pi32Vars[2] = *(optop--);
        break;
      }
      
    case astore_3:
      {
        pi32Vars[3] = *(optop--);
	break;
      }
      
    case iastore:
      {
        optop -= 3;
        if (*(optop + 1)) {
	  if ((*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number) &&
	      (*(optop + 2) >= 0)) {
#ifdef PERSIST
	    ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
#endif
	    ((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] =
	      *(optop + 3);
	  }
	  else {
	    SAVEENV();
	    pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame,
					   (int32) *(optop + 2));
	    LOADENV();
	  }
	}
	else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	}
	break;
      }
      
    case lastore:
      {
	int32 ix;
	
	optop -= 4;
	if (*(optop + 1)) {
	  if((*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number)
	     && (*(optop + 2) >= 0))
	    {
#ifdef PERSIST
	    ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
#endif
	    ix = *(optop + 2) * 2;
	    ((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[ix] =
	      *(optop + 3);
	    ((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[ix + 1] = 
	      *(optop + 4);
	  }
	  else {
	    SAVEENV();
	    pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, 
					   (int32) *(optop + 2));
	    LOADENV();
	  }
	}
	else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	}
	break;
      }

      case fastore:
      {
	optop -= 3;
	if (*(optop + 1)) {
	  if((*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number)
	     && (*(optop + 2) >= 0))
	  {
#ifdef PERSIST
	    ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
#endif
	    ((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] =
	      *(optop + 3);
	  }
	  else {
	    SAVEENV();
	    pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, 
					   (int32) *(optop + 2));
	    LOADENV();
	  }
	}
	else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	}
	break;
      }
      
    case dastore:
      {
	int32 ix;

	optop -= 4;
	if (*(optop + 1)) {
	  if((*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number) 
	     && (*(optop + 2) >= 0))
	    {
#ifdef PERSIST
	    ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
#endif
	    ix = *(optop + 2) * 2;
	    ((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[ix] =
	      *(optop + 3);
	    ((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[ix + 1] =
	      *(optop + 4);
	  }
	  else {
	    SAVEENV();
	    pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, 
					   (int32) *(optop + 2));
	    LOADENV();
	  }
	}
	else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	}
	break;
      }

    case aastore:
      {
	optop -= 3;
	if (*(optop + 1)) {
	  if((*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number)
	     && (*(optop + 2) >= 0))
	  {
#ifdef PERSIST
	    ((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] =
	      *(optop + 3);
	    ADEREF((tARREF) *(optop + 1))->i32Flags |= 
	      (PERSIST_Dirty | PERSIST_RefsDirty);
#ifdef UPDATEBITS
	    ADEREF((tARREF) *(optop + 1))->i32UpdateBits |= 
	      (1 << *(optop + 2));
#endif
#else
	    ((int32*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] =
	      *(optop + 3);
#endif
	  }
	  else {
	    SAVEENV();
	    pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, 
					   (int32) *(optop + 2));
	    LOADENV();
	  }
	}
	else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	}
	break;
      }

    case bastore:
      {
	optop -= 3;
	if (*(optop + 1)) {
	  if (((*(optop + 2)) < ADEREF((tARREF) *(optop + 1))->i32Number) &&
	      (*(optop + 2) >= 0)) {
#ifdef PERSIST
	    ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
#endif
	    //Should I at least cast this to a char?
	    ((byte*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] =
	      (char) *(optop + 3);
	  }
	  else {
	    SAVEENV();
	    pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, 
					   (int32) *(optop + 2));
	    LOADENV();
	  }
	}
	else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	}
	break;
      }

      case castore:
      {
	optop -= 3;
	if (*(optop + 1)) {
	  if((*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number) 
	     && (*(optop + 2) >= 0))
	    {
#ifdef PERSIST
	    ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
#endif
	    ((uint16*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] = 
	      *(optop + 3);
	  }
	  else {
	    SAVEENV();
	    pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, 
					   (int32) *(optop + 2));
	    LOADENV();
	  }
	}
	else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	}
	break;
      }
      
    case sastore:
      {
	optop -= 3;
	if (*(optop + 1)) {
	  if ((*(optop + 2) >= 0) && 
	      (*(optop + 2) < ADEREF((tARREF) *(optop + 1))->i32Number)) {
#ifdef PERSIST
	    ADEREF((tARREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
#endif
	    ((int16*) ADEREF((tARREF) *(optop + 1))->pvElements)[*(optop + 2)] =
	      *(optop + 3);
	  }
	  else {
	    SAVEENV();
	    pstCurrFrame = ThrowArrayIndex(env, pstCurrFrame, 
					   (int32) *(optop + 2));
	    LOADENV();
	  }
	}
	else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	}
	break;
      }
      
