/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KISSME_JNI_H__
#define __KISSME_JNI_H__

#include "config.h"

#ifdef __GCJ_JNI_H__
#error You have included a GJC jni.h!
#endif

#ifdef _JAVASOFT_JNI_H_
#error You have included a Sun/JDK jni.h!
#endif

#ifdef __CLASSPATH_JNI_H__
#error You have included a Classpath jni.h!
#endif

#include "vm/interp.h"
#include "vm/classfil.h"
#include "vm/stdtypes.h"

#ifdef KISSME_LINUX_USER
#include <stdarg.h>
#include <malloc.h>
#endif

#ifdef KISSME_RJK_KERNEL
#include <stdarg.h>
#endif

#ifndef KISSME_LINUX_KERNEL
#include <stdarg.h>
#endif

#define _JNI_VM_INTERNAL_TYPES_DEFINED
typedef tOBREF jobject;
typedef tMethod* jmethodID;
typedef tField* jfieldID;

/*
 * This is an inline expansion of the patched version of Classpath's 
 * 'include/jni.h' file.  When the patches are added to the Classpath
 * CVS, this inlining should be replaced with a #include.
 */

/* jni.h
   Copyright (C) 2001 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.
 
GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

/* This file is based on jni.h from libgcj */

#ifndef __CLASSPATH_JNI_H__
#define __CLASSPATH_JNI_H__

#include <stdarg.h>

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

#define JNI_EXTENSIONS kissme

/*
 * Inlined the Classpath jni_md.h file
 */

/* Define some defaults */
#define JNICALL
#define JNIEXPORT

typedef unsigned char jboolean;
typedef signed char jbyte;
typedef unsigned short jchar;
typedef short jshort;
typedef int jint;
typedef long long jlong;
typedef float jfloat;
typedef double jdouble;

/* 
 * ... end of jni_md.h
 */

typedef jint jsize;
  
#ifdef __cplusplus
}
#endif
  
#ifdef __cplusplus
  
class _jobject {};
class _jclass : public _jobject {};
class _jthrowable : public _jobject {};
class _jstring : public _jobject {};
class _jarray : public _jobject {};
class _jbooleanArray : public _jarray {};
class _jbyteArray : public _jarray {};
class _jcharArray : public _jarray {};
class _jshortArray : public _jarray {};
class _jintArray : public _jarray {};
class _jlongArray : public _jarray {};
class _jfloatArray : public _jarray {};
class _jdoubleArray : public _jarray {};
class _jobjectArray : public _jarray {};

typedef _jobject *jobject;
typedef _jclass *jclass;
typedef _jthrowable *jthrowable;
typedef _jstring *jstring;
typedef _jarray *jarray;
typedef _jbooleanArray *jbooleanArray;
typedef _jbyteArray *jbyteArray;
typedef _jcharArray *jcharArray;
typedef _jshortArray *jshortArray;
typedef _jintArray *jintArray;
typedef _jlongArray *jlongArray;
typedef _jfloatArray *jfloatArray;
typedef _jdoubleArray *jdoubleArray;
typedef _jobjectArray *jobjectArray;

typedef struct _Jv_JNIEnv JNIEnv;
typedef struct _Jv_JavaVM JavaVM;

#else /* __cplusplus */

#ifdef JNI_EXTENSIONS
#include "jni_ext-kissme.h"
/* 
 * A JNI extensions header file is used to define non-standard extensions
 *    to the JNINativeInterface struct (see below).  It should #define
 *    the following C macros.
 * JNI_EXTENSION_FUNCTIONS should define the additional fields for the
 *    JNINativeInterface struct.  It is #included aafter the last standard
 *    field of the struct.
 * JNI_EXTENSION_TYPES gives dummy typedefs for any VM specific types
 *    used in the extension methods' signatures.
 */	
#endif

/* 
 * Before jni.h is #included within a typical JVM, the source code should 
 * #define _JNI_VM_INTERNAL_TYPES_DEFINED and provide the real declarations
 * for 'jobject', 'jfieldID', 'jMethodID' and other implementation types.
 * If _JNI_VM_INTERNAL_TYPES_DEFINED is not defined, the following 
 * declares dummy versions of the types.
 */
#ifndef _JNI_VM_INTERNAL_TYPES_DEFINED
typedef void *jobject;
typedef void *jfieldID;
typedef void *jmethodID;
#ifdef JNI_EXTENSIONS
JNI_EXTENSION_TYPES
#endif
#endif 

typedef jobject jclass;
typedef jobject jstring;
typedef jobject jarray;
typedef jobject jthrowable;
typedef jobject jobjectArray;
typedef jobject jbyteArray;
typedef jobject jshortArray;
typedef jobject jintArray;
typedef jobject jlongArray;
typedef jobject jbooleanArray;
typedef jobject jcharArray;
typedef jobject jfloatArray;
typedef jobject jdoubleArray;
  
/* Dummy defines.  */
typedef const struct JNINativeInterface *JNIEnv;
typedef const struct JNIInvokeInterface *JavaVM;

#endif /* __cplusplus */

#ifdef __cplusplus
typedef void * (*_Jv_func) (...);
#else
typedef void * (*_Jv_func) ();  
#endif

#define _Jv_va_list va_list

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

typedef union jvalue
{
  jboolean z;
  jbyte    b;
  jchar    c;
  jshort   s;
  jint     i;
  jlong    j;
  jfloat   f;
  jdouble  d;
  jobject  l;
} jvalue;

      
/* Used for jboolean type  */
#define JNI_TRUE  1
#define JNI_FALSE 0
  
/* Used when releasing array elements.  */
#define JNI_COMMIT 1
#define JNI_ABORT  2

/* FIXME: Could be wrong */
typedef jobject jweak;  

/* Version numbers.  */
#define JNI_VERSION_1_1 0x00010001 /* JNI version 1.1 */
#define JNI_VERSION_1_2 0x00010002 /* JNI version 1.2 */
#define JNI_VERSION_1_4 0x00010004 /* JNI version 1.4 */
    
/* Error codes */
#define JNI_OK            0
#define JNI_ERR          (-1)
#define JNI_EDETACHED    (-2)
#define JNI_EVERSION     (-3)
  
/* These functions might be defined in a native libraries; the JVM's
   JNI implementation calls them at the appropriate times.  If 
   JNI_OnLoad is defined, it should return the JNI_VERSION number 
   expected by the native library. */
JNIEXPORT jint JNICALL JNI_OnLoad (JavaVM *, void *);
JNIEXPORT void JNICALL JNI_OnUnload (JavaVM *, void *);
    
/* These functions are called by user code to start using the
   invocation API.  */
JNIEXPORT jint JNICALL JNI_GetDefaultJavaVMInitArgs (void *);
JNIEXPORT jint JNICALL JNI_CreateJavaVM (JavaVM **, void **, void *);
JNIEXPORT jint JNICALL JNI_GetCreatedJavaVMs(JavaVM **, jsize, jsize *);

/* This structure is used when registering native methods.  */
typedef struct
{
  char *name;
  char *signature;
  void *fnPtr;
} JNINativeMethod;


struct JNINativeInterface
{
  _Jv_func reserved0;                                                                /* 0 */
  _Jv_func reserved1;                                                                /* 1 */
  _Jv_func reserved2;                                                                /* 2 */
  _Jv_func reserved3;                                                                /* 3 */

  jint     (JNICALL *GetVersion)                   (JNIEnv *);                               /* 4 */
  jclass   (JNICALL *DefineClass)                  (JNIEnv *, const char *, jobject, const jbyte *, jsize); /* 5 */
  jclass   (JNICALL *FindClass)                    (JNIEnv *, const char *);                 /* 6 */

  jmethodID (JNICALL *FromReflectedMethod)	   (JNIEnv *, jobject);                      /* 7 */
  jfieldID  (JNICALL *FromReflectedField)	   (JNIEnv *, jobject);                      /* 8 */
  jobject   (JNICALL *ToReflectedMethod)	   (JNIEnv *, jclass, jmethodID, jboolean);  /* 9 */

  jclass   (JNICALL *GetSuperclass)                (JNIEnv *, jclass);                       /* 10 */
  jboolean (JNICALL *IsAssignableFrom)             (JNIEnv *, jclass, jclass);               /* 11 */

  jobject  (JNICALL *ToReflectedField)		   (JNIEnv *, jclass, jfieldID, jboolean);   /* 12 */

  jint     (JNICALL *Throw)                        (JNIEnv *, jthrowable);                   /* 13 */
  jint     (JNICALL *ThrowNew)                     (JNIEnv *, jclass, const char *);         /* 14 */
  jthrowable (JNICALL *ExceptionOccurred)          (JNIEnv *);                               /* 15 */
  void     (JNICALL *ExceptionDescribe)            (JNIEnv *);                               /* 16 */
  void     (JNICALL *ExceptionClear)               (JNIEnv *);                               /* 17 */
  void     (JNICALL *FatalError)                   (JNIEnv *, const char *);                 /* 18 */

  jint     (JNICALL *PushLocalFrame)		   (JNIEnv *, jint);                         /* 19 */
  jobject  (JNICALL *PopLocalFrame)		   (JNIEnv *, jobject);                      /* 20 */

  jobject  (JNICALL *NewGlobalRef)                 (JNIEnv *, jobject);                      /* 21 */
  void     (JNICALL *DeleteGlobalRef)              (JNIEnv *, jobject);                      /* 22 */
  void     (JNICALL *DeleteLocalRef)               (JNIEnv *, jobject);                      /* 23 */
  jboolean (JNICALL *IsSameObject)                 (JNIEnv *, jobject, jobject);             /* 24 */

  jobject  (JNICALL *NewLocalRef)		   (JNIEnv *, jobject);                      /* 25 */
  jint     (JNICALL *EnsureLocalCapacity)	   (JNIEnv *, jint);                         /* 26 */

  jobject  (JNICALL *AllocObject)                  (JNIEnv *, jclass);                       /* 27 */
  jobject (JNICALL *NewObject)			   (JNIEnv *, jclass, jmethodID, ...);       /* 28 */
  jobject (JNICALL *NewObjectV)			   (JNIEnv *, jclass, jmethodID, _Jv_va_list); /* 29 */
  jobject (JNICALL *NewObjectA)			   (JNIEnv *, jclass, jmethodID, jvalue *);  /* 30 */

  jclass   (JNICALL *GetObjectClass)               (JNIEnv *, jobject);                      /* 31 */
  jboolean (JNICALL *IsInstanceOf)                 (JNIEnv *, jobject, jclass);              /* 32 */
  jmethodID (JNICALL *GetMethodID)                 (JNIEnv *, jclass, const char *, const char *); /* 33 */

  jobject 	(JNICALL *CallObjectMethod)	   (JNIEnv *, jobject, jmethodID, ...);         /* 34 */
  jobject 	(JNICALL *CallObjectMethodV)	   (JNIEnv *, jobject, jmethodID, _Jv_va_list); /* 35 */
  jobject 	(JNICALL *CallObjectMethodA)	   (JNIEnv *, jobject, jmethodID, jvalue *);    /* 36 */
  jboolean 	(JNICALL *CallBooleanMethod)	   (JNIEnv *, jobject, jmethodID, ...);         /* 37 */
  jboolean 	(JNICALL *CallBooleanMethodV)	   (JNIEnv *, jobject, jmethodID, _Jv_va_list); /* 38 */
  jboolean 	(JNICALL *CallBooleanMethodA)	   (JNIEnv *, jobject, jmethodID, jvalue *);    /* 39 */
  jbyte 	(JNICALL *CallByteMethod)	   (JNIEnv *, jobject, jmethodID, ...);         /* 40 */
  jbyte 	(JNICALL *CallByteMethodV)	   (JNIEnv *, jobject, jmethodID, _Jv_va_list); /* 41 */
  jbyte 	(JNICALL *CallByteMethodA)	   (JNIEnv *, jobject, jmethodID, jvalue *);    /* 42 */
  jchar 	(JNICALL *CallCharMethod)	   (JNIEnv *, jobject, jmethodID, ...);         /* 43 */
  jchar 	(JNICALL *CallCharMethodV)	   (JNIEnv *, jobject, jmethodID, _Jv_va_list); /* 44 */
  jchar 	(JNICALL *CallCharMethodA)	   (JNIEnv *, jobject, jmethodID, jvalue *);    /* 45 */
  jshort 	(JNICALL *CallShortMethod)	   (JNIEnv *, jobject, jmethodID, ...);         /* 46 */
  jshort 	(JNICALL *CallShortMethodV)	   (JNIEnv *, jobject, jmethodID, _Jv_va_list); /* 47 */
  jshort 	(JNICALL *CallShortMethodA)	   (JNIEnv *, jobject, jmethodID, jvalue *);    /* 48 */
  jint 		(JNICALL *CallIntMethod)	   (JNIEnv *, jobject, jmethodID, ...);         /* 49 */
  jint 		(JNICALL *CallIntMethodV)	   (JNIEnv *, jobject, jmethodID, _Jv_va_list); /* 50 */
  jint 		(JNICALL *CallIntMethodA)	   (JNIEnv *, jobject, jmethodID, jvalue *);    /* 51 */
  jlong 	(JNICALL *CallLongMethod)	   (JNIEnv *, jobject, jmethodID, ...);         /* 52 */
  jlong 	(JNICALL *CallLongMethodV)	   (JNIEnv *, jobject, jmethodID, _Jv_va_list); /* 53 */
  jlong 	(JNICALL *CallLongMethodA)	   (JNIEnv *, jobject, jmethodID, jvalue *);    /* 54 */
  jfloat 	(JNICALL *CallFloatMethod)	   (JNIEnv *, jobject, jmethodID, ...);         /* 55 */
  jfloat 	(JNICALL *CallFloatMethodV)	   (JNIEnv *, jobject, jmethodID, _Jv_va_list); /* 56 */
  jfloat 	(JNICALL *CallFloatMethodA)	   (JNIEnv *, jobject, jmethodID, jvalue *);    /* 57 */
  jdouble 	(JNICALL *CallDoubleMethod)	   (JNIEnv *, jobject, jmethodID, ...);         /* 58 */
  jdouble 	(JNICALL *CallDoubleMethodV)	   (JNIEnv *, jobject, jmethodID, _Jv_va_list); /* 59 */
  jdouble 	(JNICALL *CallDoubleMethodA)	   (JNIEnv *, jobject, jmethodID, jvalue *);    /* 60 */
  void  	(JNICALL *CallVoidMethod)	   (JNIEnv *, jobject, jmethodID, ...);         /* 61 */
  void  	(JNICALL *CallVoidMethodV)	   (JNIEnv *, jobject, jmethodID, _Jv_va_list); /* 62 */
  void  	(JNICALL *CallVoidMethodA)	   (JNIEnv *, jobject, jmethodID, jvalue *);    /* 63 */

  jobject   (JNICALL *CallNonvirtualObjectMethod)  (JNIEnv *, jobject, jclass, jmethodID, ...);          /* 64 */
  jobject   (JNICALL *CallNonvirtualObjectMethodV) (JNIEnv *, jobject, jclass, jmethodID, _Jv_va_list);  /* 65 */
  jobject   (JNICALL *CallNonvirtualObjectMethodA) (JNIEnv *, jobject, jclass, jmethodID, jvalue *);     /* 66 */
  jboolean  (JNICALL *CallNonvirtualBooleanMethod) (JNIEnv *, jobject, jclass, jmethodID, ...);          /* 67 */
  jboolean  (JNICALL *CallNonvirtualBooleanMethodV) (JNIEnv *, jobject, jclass, jmethodID, _Jv_va_list); /* 68 */
  jboolean  (JNICALL *CallNonvirtualBooleanMethodA) (JNIEnv *, jobject, jclass, jmethodID, jvalue *);    /* 69 */
  jbyte     (JNICALL *CallNonvirtualByteMethod)	   (JNIEnv *, jobject, jclass, jmethodID, ...);          /* 70 */
  jbyte     (JNICALL *CallNonvirtualByteMethodV)   (JNIEnv *, jobject, jclass, jmethodID, _Jv_va_list);  /* 71 */
  jbyte     (JNICALL *CallNonvirtualByteMethodA)   (JNIEnv *, jobject, jclass, jmethodID, jvalue *);     /* 72 */
  jchar     (JNICALL *CallNonvirtualCharMethod)	   (JNIEnv *, jobject, jclass, jmethodID, ...);          /* 73 */
  jchar     (JNICALL *CallNonvirtualCharMethodV)   (JNIEnv *, jobject, jclass, jmethodID, _Jv_va_list);  /* 74 */
  jchar     (JNICALL *CallNonvirtualCharMethodA)   (JNIEnv *, jobject, jclass, jmethodID, jvalue *);     /* 75 */
  jshort    (JNICALL *CallNonvirtualShortMethod)   (JNIEnv *, jobject, jclass, jmethodID, ...);          /* 76 */
  jshort    (JNICALL *CallNonvirtualShortMethodV)  (JNIEnv *, jobject, jclass, jmethodID, _Jv_va_list);  /* 77 */
  jshort    (JNICALL *CallNonvirtualShortMethodA)  (JNIEnv *, jobject, jclass, jmethodID, jvalue *);     /* 78 */
  jint 	    (JNICALL *CallNonvirtualIntMethod)	   (JNIEnv *, jobject, jclass, jmethodID, ...);          /* 79 */
  jint 	    (JNICALL *CallNonvirtualIntMethodV)	   (JNIEnv *, jobject, jclass, jmethodID, _Jv_va_list);  /* 80 */
  jint 	    (JNICALL *CallNonvirtualIntMethodA)	   (JNIEnv *, jobject, jclass, jmethodID, jvalue *);     /* 81 */
  jlong     (JNICALL *CallNonvirtualLongMethod)	   (JNIEnv *, jobject, jclass, jmethodID, ...);          /* 82 */
  jlong     (JNICALL *CallNonvirtualLongMethodV)   (JNIEnv *, jobject, jclass, jmethodID, _Jv_va_list);  /* 83 */
  jlong     (JNICALL *CallNonvirtualLongMethodA)   (JNIEnv *, jobject, jclass, jmethodID, jvalue *);     /* 84 */
  jfloat    (JNICALL *CallNonvirtualFloatMethod)   (JNIEnv *, jobject, jclass, jmethodID, ...);          /* 85 */
  jfloat    (JNICALL *CallNonvirtualFloatMethodV)  (JNIEnv *, jobject, jclass, jmethodID, _Jv_va_list);  /* 86 */
  jfloat    (JNICALL *CallNonvirtualFloatMethodA)  (JNIEnv *, jobject, jclass, jmethodID, jvalue *);     /* 87 */
  jdouble   (JNICALL *CallNonvirtualDoubleMethod)  (JNIEnv *, jobject, jclass, jmethodID, ...);          /* 88 */
  jdouble   (JNICALL *CallNonvirtualDoubleMethodV) (JNIEnv *, jobject, jclass, jmethodID, _Jv_va_list);  /* 89 */
  jdouble   (JNICALL *CallNonvirtualDoubleMethodA) (JNIEnv *, jobject, jclass, jmethodID, jvalue *);     /* 90 */
  void      (JNICALL *CallNonvirtualVoidMethod)	   (JNIEnv *, jobject, jclass, jmethodID, ...);          /* 91 */
  void      (JNICALL *CallNonvirtualVoidMethodV)   (JNIEnv *, jobject, jclass, jmethodID, _Jv_va_list);  /* 92 */
  void      (JNICALL *CallNonvirtualVoidMethodA)   (JNIEnv *, jobject, jclass, jmethodID, jvalue *);     /* 93 */

  jfieldID      (JNICALL *GetFieldID)              (JNIEnv *, jclass, const char *, const char *);  /* 94 */

  jobject  (JNICALL *GetObjectField)               (JNIEnv *, jobject, jfieldID);                   /* 95 */
  jboolean (JNICALL *GetBooleanField)              (JNIEnv *, jobject, jfieldID);                   /* 96 */
  jbyte    (JNICALL *GetByteField)                 (JNIEnv *, jobject, jfieldID);                   /* 97 */
  jchar    (JNICALL *GetCharField)                 (JNIEnv *, jobject, jfieldID);                   /* 98 */
  jshort   (JNICALL *GetShortField)                (JNIEnv *, jobject, jfieldID);                   /* 99 */
  jint     (JNICALL *GetIntField)                  (JNIEnv *, jobject, jfieldID);                   /* 100 */
  jlong    (JNICALL *GetLongField)                 (JNIEnv *, jobject, jfieldID);                   /* 101 */
  jfloat   (JNICALL *GetFloatField)                (JNIEnv *, jobject, jfieldID);                   /* 102 */
  jdouble  (JNICALL *GetDoubleField)               (JNIEnv *, jobject, jfieldID);                   /* 103 */

  void		(JNICALL *SetObjectField)	   (JNIEnv *, jobject, jfieldID, jobject);          /* 104 */
  void		(JNICALL *SetBooleanField)	   (JNIEnv *, jobject, jfieldID, jboolean);         /* 105 */
  void		(JNICALL *SetByteField)		   (JNIEnv *, jobject, jfieldID, jbyte);            /* 106 */
  void		(JNICALL *SetCharField)		   (JNIEnv *, jobject, jfieldID, jchar);            /* 107 */
  void		(JNICALL *SetShortField)	   (JNIEnv *, jobject, jfieldID, jshort);           /* 108 */
  void		(JNICALL *SetIntField)		   (JNIEnv *, jobject, jfieldID, jint);             /* 109 */
  void		(JNICALL *SetLongField)		   (JNIEnv *, jobject, jfieldID, jlong);            /* 110 */
  void		(JNICALL *SetFloatField)	   (JNIEnv *, jobject, jfieldID, jfloat);           /* 111 */
  void		(JNICALL *SetDoubleField)	   (JNIEnv *, jobject, jfieldID, jdouble);          /* 112 */

  jmethodID (JNICALL *GetStaticMethodID)           (JNIEnv *, jclass, const char *, const char *);  /* 113 */

  jobject 	(JNICALL *CallStaticObjectMethod)  (JNIEnv *, jclass, jmethodID, ...);              /* 114 */
  jobject 	(JNICALL *CallStaticObjectMethodV) (JNIEnv *, jclass, jmethodID, _Jv_va_list);      /* 115 */
  jobject 	(JNICALL *CallStaticObjectMethodA) (JNIEnv *, jclass, jmethodID, jvalue *);         /* 116 */
  jboolean 	(JNICALL *CallStaticBooleanMethod) (JNIEnv *, jclass, jmethodID, ...);              /* 117 */
  jboolean 	(JNICALL *CallStaticBooleanMethodV) (JNIEnv *, jclass, jmethodID, _Jv_va_list);     /* 118 */
  jboolean 	(JNICALL *CallStaticBooleanMethodA) (JNIEnv *, jclass, jmethodID, jvalue *);        /* 119 */
  jbyte 	(JNICALL *CallStaticByteMethod)    (JNIEnv *, jclass, jmethodID, ...);              /* 120 */
  jbyte 	(JNICALL *CallStaticByteMethodV)   (JNIEnv *, jclass, jmethodID, _Jv_va_list);      /* 121 */
  jbyte 	(JNICALL *CallStaticByteMethodA)   (JNIEnv *, jclass, jmethodID, jvalue *);         /* 122 */
  jchar 	(JNICALL *CallStaticCharMethod)    (JNIEnv *, jclass, jmethodID, ...);              /* 123 */
  jchar 	(JNICALL *CallStaticCharMethodV)   (JNIEnv *, jclass, jmethodID, _Jv_va_list);      /* 124 */
  jchar 	(JNICALL *CallStaticCharMethodA)   (JNIEnv *, jclass, jmethodID, jvalue *);         /* 125 */
  jshort 	(JNICALL *CallStaticShortMethod)   (JNIEnv *, jclass, jmethodID, ...);              /* 126 */
  jshort 	(JNICALL *CallStaticShortMethodV)  (JNIEnv *, jclass, jmethodID, _Jv_va_list);      /* 127 */
  jshort 	(JNICALL *CallStaticShortMethodA)  (JNIEnv *, jclass, jmethodID, jvalue *);         /* 128 */
  jint 		(JNICALL *CallStaticIntMethod) 	   (JNIEnv *, jclass, jmethodID, ...);              /* 129 */
  jint 		(JNICALL *CallStaticIntMethodV)    (JNIEnv *, jclass, jmethodID, _Jv_va_list);      /* 130 */
  jint 		(JNICALL *CallStaticIntMethodA)    (JNIEnv *, jclass, jmethodID, jvalue *);         /* 131 */
  jlong 	(JNICALL *CallStaticLongMethod)    (JNIEnv *, jclass, jmethodID, ...);              /* 132 */
  jlong 	(JNICALL *CallStaticLongMethodV)   (JNIEnv *, jclass, jmethodID, _Jv_va_list);      /* 133 */
  jlong 	(JNICALL *CallStaticLongMethodA)   (JNIEnv *, jclass, jmethodID, jvalue *);         /* 134 */
  jfloat 	(JNICALL *CallStaticFloatMethod)   (JNIEnv *, jclass, jmethodID, ...);              /* 135 */
  jfloat 	(JNICALL *CallStaticFloatMethodV)  (JNIEnv *, jclass, jmethodID, _Jv_va_list);      /* 136 */
  jfloat 	(JNICALL *CallStaticFloatMethodA)  (JNIEnv *, jclass, jmethodID, jvalue *);         /* 137 */
  jdouble 	(JNICALL *CallStaticDoubleMethod)  (JNIEnv *, jclass, jmethodID, ...);              /* 138 */
  jdouble 	(JNICALL *CallStaticDoubleMethodV) (JNIEnv *, jclass, jmethodID, _Jv_va_list);      /* 139 */
  jdouble 	(JNICALL *CallStaticDoubleMethodA) (JNIEnv *, jclass, jmethodID, jvalue *);         /* 140 */
  void  	(JNICALL *CallStaticVoidMethod)    (JNIEnv *, jclass, jmethodID, ...);              /* 141 */
  void  	(JNICALL *CallStaticVoidMethodV)   (JNIEnv *, jclass, jmethodID, _Jv_va_list);      /* 142 */
  void  	(JNICALL *CallStaticVoidMethodA)   (JNIEnv *, jclass, jmethodID, jvalue *);         /* 143 */

  jfieldID      (JNICALL *GetStaticFieldID)        (JNIEnv *, jclass, const char *, const char *);  /* 144 */

  jobject	(JNICALL *GetStaticObjectField)	   (JNIEnv *, jclass, jfieldID);                    /* 145 */
  jboolean	(JNICALL *GetStaticBooleanField)   (JNIEnv *, jclass, jfieldID);                    /* 146 */
  jbyte		(JNICALL *GetStaticByteField)	   (JNIEnv *, jclass, jfieldID);                    /* 147 */
  jchar		(JNICALL *GetStaticCharField)	   (JNIEnv *, jclass, jfieldID);                    /* 148 */
  jshort	(JNICALL *GetStaticShortField)	   (JNIEnv *, jclass, jfieldID);                    /* 149 */
  jint		(JNICALL *GetStaticIntField)	   (JNIEnv *, jclass, jfieldID);                    /* 150 */
  jlong		(JNICALL *GetStaticLongField)	   (JNIEnv *, jclass, jfieldID);                    /* 151 */
  jfloat	(JNICALL *GetStaticFloatField)	   (JNIEnv *, jclass, jfieldID);                    /* 152 */
  jdouble	(JNICALL *GetStaticDoubleField)	   (JNIEnv *, jclass, jfieldID);                    /* 153 */

  void 		(JNICALL *SetStaticObjectField)	   (JNIEnv *, jclass, jfieldID, jobject);           /* 154 */
  void 		(JNICALL *SetStaticBooleanField)   (JNIEnv *, jclass, jfieldID, jboolean);          /* 155 */
  void 		(JNICALL *SetStaticByteField)	   (JNIEnv *, jclass, jfieldID, jbyte);             /* 156 */
  void 		(JNICALL *SetStaticCharField)	   (JNIEnv *, jclass, jfieldID, jchar);             /* 157 */
  void 		(JNICALL *SetStaticShortField)	   (JNIEnv *, jclass, jfieldID, jshort);            /* 158 */
  void 		(JNICALL *SetStaticIntField)	   (JNIEnv *, jclass, jfieldID, jint);              /* 159 */
  void 		(JNICALL *SetStaticLongField)	   (JNIEnv *, jclass, jfieldID, jlong);             /* 160 */
  void 		(JNICALL *SetStaticFloatField)	   (JNIEnv *, jclass, jfieldID, jfloat);            /* 161 */
  void 		(JNICALL *SetStaticDoubleField)	   (JNIEnv *, jclass, jfieldID, jdouble);           /* 162 */

  jstring  (JNICALL *NewString)                    (JNIEnv *, const jchar *, jsize);                /* 163 */
  jsize    (JNICALL *GetStringLength)              (JNIEnv *, jstring);                             /* 164 */
  const jchar * (JNICALL *GetStringChars)          (JNIEnv *, jstring, jboolean *);                 /* 165 */
  void     (JNICALL *ReleaseStringChars)           (JNIEnv *, jstring, const jchar *);              /* 166 */
  jstring  (JNICALL *NewStringUTF)                 (JNIEnv *, const char *);                        /* 167 */
  jsize    (JNICALL *GetStringUTFLength)           (JNIEnv *, jstring);                             /* 168 */
  const jbyte * (JNICALL *GetStringUTFChars)       (JNIEnv *, jstring, jboolean *);                 /* 169 */
  void     (JNICALL *ReleaseStringUTFChars)        (JNIEnv *, jstring, const char *);               /* 170 */
  jsize    (JNICALL *GetArrayLength)               (JNIEnv *, jarray);                              /* 171 */
  jarray   (JNICALL *NewObjectArray)               (JNIEnv *, jsize, jclass, jobject);              /* 172 */
  jobject  (JNICALL *GetObjectArrayElement)        (JNIEnv *, jobjectArray, jsize);                 /* 173 */
  void     (JNICALL *SetObjectArrayElement)        (JNIEnv *, jobjectArray, jsize, jobject);        /* 174 */

  jbooleanArray (JNICALL *NewBooleanArray)	   (JNIEnv *, jsize);                               /* 175 */
  jbyteArray    (JNICALL *NewByteArray)		   (JNIEnv *, jsize);                               /* 176 */
  jcharArray    (JNICALL *NewCharArray)		   (JNIEnv *, jsize);                               /* 177 */
  jshortArray   (JNICALL *NewShortArray)	   (JNIEnv *, jsize);                               /* 178 */
  jintArray     (JNICALL *NewIntArray)		   (JNIEnv *, jsize);                               /* 179 */
  jlongArray    (JNICALL *NewLongArray)		   (JNIEnv *, jsize);                               /* 180 */
  jfloatArray   (JNICALL *NewFloatArray)	   (JNIEnv *, jsize);                               /* 181 */
  jdoubleArray  (JNICALL *NewDoubleArray)	   (JNIEnv *, jsize);                               /* 182 */

  jboolean *	(JNICALL *GetBooleanArrayElements) (JNIEnv *, jbooleanArray, jboolean *);           /* 183 */
  jbyte *	(JNICALL *GetByteArrayElements)	   (JNIEnv *, jbyteArray, jboolean *);              /* 184 */
  jchar *	(JNICALL *GetCharArrayElements)	   (JNIEnv *, jcharArray, jboolean *);              /* 185 */
  jshort *	(JNICALL *GetShortArrayElements)   (JNIEnv *, jshortArray, jboolean *);             /* 186 */
  jint *	(JNICALL *GetIntArrayElements)	   (JNIEnv *, jintArray, jboolean *);               /* 187 */
  jlong *	(JNICALL *GetLongArrayElements)	   (JNIEnv *, jlongArray, jboolean *);              /* 188 */
  jfloat *	(JNICALL *GetFloatArrayElements)   (JNIEnv *, jfloatArray, jboolean *);             /* 189 */
  jdouble *	(JNICALL *GetDoubleArrayElements)  (JNIEnv *, jdoubleArray, jboolean *);            /* 190 */

  void		(JNICALL *ReleaseBooleanArrayElements) (JNIEnv *, jbooleanArray, jboolean *, jint); /* 191 */
  void		(JNICALL *ReleaseByteArrayElements)    (JNIEnv *, jbyteArray, jbyte *, jint);       /* 192 */
  void		(JNICALL *ReleaseCharArrayElements)    (JNIEnv *, jcharArray, jchar *, jint);       /* 193 */
  void		(JNICALL *ReleaseShortArrayElements)   (JNIEnv *, jshortArray, jshort *, jint);     /* 194 */
  void		(JNICALL *ReleaseIntArrayElements)     (JNIEnv *, jintArray, jint *, jint);         /* 195 */
  void		(JNICALL *ReleaseLongArrayElements)    (JNIEnv *, jlongArray, jlong *, jint);       /* 196 */
  void		(JNICALL *ReleaseFloatArrayElements)   (JNIEnv *, jfloatArray, jfloat *, jint);     /* 197 */
  void		(JNICALL *ReleaseDoubleArrayElements)  (JNIEnv *, jdoubleArray, jdouble *, jint);   /* 198 */

  void 		(JNICALL *GetBooleanArrayRegion)   (JNIEnv *, jbooleanArray,jsize, jsize, jboolean *);  /* 199 */
  void 		(JNICALL *GetByteArrayRegion)	   (JNIEnv *, jbyteArray, jsize, jsize, jbyte *);       /* 200 */
  void 		(JNICALL *GetCharArrayRegion)	   (JNIEnv *, jcharArray, jsize, jsize, jchar *);       /* 201 */
  void 		(JNICALL *GetShortArrayRegion)	   (JNIEnv *, jshortArray, jsize, jsize, jshort *);     /* 202 */
  void 		(JNICALL *GetIntArrayRegion)	   (JNIEnv *, jintArray, jsize, jsize, jint *);         /* 203 */
  void 		(JNICALL *GetLongArrayRegion)	   (JNIEnv *, jlongArray, jsize, jsize, jlong *);       /* 204 */
  void 		(JNICALL *GetFloatArrayRegion)	   (JNIEnv *, jfloatArray, jsize, jsize, jfloat *);     /* 205 */
  void 		(JNICALL *GetDoubleArrayRegion)	   (JNIEnv *, jdoubleArray, jsize, jsize, jdouble *);   /* 206 */

  void 		(JNICALL *SetBooleanArrayRegion)   (JNIEnv *, jbooleanArray, jsize, jsize, jboolean *); /* 207 */
  void 		(JNICALL *SetByteArrayRegion)	   (JNIEnv *, jbyteArray, jsize, jsize, jbyte *);       /* 208 */
  void 		(JNICALL *SetCharArrayRegion)	   (JNIEnv *, jcharArray, jsize, jsize, jchar *);       /* 209 */
  void 		(JNICALL *SetShortArrayRegion)	   (JNIEnv *, jshortArray, jsize, jsize, jshort *);     /* 210 */
  void 		(JNICALL *SetIntArrayRegion)	   (JNIEnv *, jintArray, jsize, jsize, jint *);         /* 211 */
  void 		(JNICALL *SetLongArrayRegion)	   (JNIEnv *, jlongArray, jsize, jsize, jlong *);       /* 212 */
  void 		(JNICALL *SetFloatArrayRegion)	   (JNIEnv *, jfloatArray, jsize, jsize, jfloat *);     /* 213 */
  void 		(JNICALL *SetDoubleArrayRegion)	   (JNIEnv *, jdoubleArray, jsize, jsize, jdouble *);   /* 214 */

  jint     (JNICALL *RegisterNatives)              (JNIEnv *, jclass, const JNINativeMethod *, jint);   /* 215 */
  jint     (JNICALL *UnregisterNatives)            (JNIEnv *, jclass);                                  /* 216 */
  jint     (JNICALL *MonitorEnter)                 (JNIEnv *, jobject);                                 /* 217 */
  jint     (JNICALL *MonitorExit)                  (JNIEnv *, jobject);                                 /* 218 */
  jint     (JNICALL *GetJavaVM)                    (JNIEnv *, JavaVM **);                               /* 219 */

  /* ---- JNI 1.2 functions ---- */
  void	   (JNICALL *GetStringRegion)	           (JNIEnv *, jstring, jsize, jsize, jchar *);          /* 220 */
  void     (JNICALL *GetStringUTFRegion)	   (JNIEnv *, jstring, jsize, jsize, char *);           /* 221 */

  void * (JNICALL *GetPrimitiveArrayCritical)      (JNIEnv *, jarray, jboolean *);                      /* 222 */
  void   (JNICALL *ReleasePrimitiveArrayCritical)  (JNIEnv *, jarray, void *, jint);                    /* 223 */

  const jchar * (JNICALL *GetStringCritical)       (JNIEnv *, jstring, jboolean *);                     /* 224 */
  void          (JNICALL *ReleaseStringCritical)   (JNIEnv *, jstring, const jchar *);                  /* 225 */

  jweak  (JNICALL *NewWeakGlobalRef)               (JNIEnv *, jobject);                                 /* 226 */
  void   (JNICALL *DeleteWeakGlobalRef)            (JNIEnv *, jweak);                                   /* 227 */

  jboolean	(JNICALL *ExceptionCheck)	   (JNIEnv *);                                          /* 228 */

  /* ---- JNI 1.4 functions ---- */
  jobject       (JNICALL *NewDirectByteBuffer)     (JNIEnv *, void *, jlong);
                         /* 229 */
  void *        (JNICALL *GetDirectBufferAddress)  (JNIEnv *, jobject);                                 /* 230 */
  long          (JNICALL *GetDirectBufferCapacity) (JNIEnv *, jobject);                                 /* 231 */
};


/*
 * Invocation API.
 */

struct JNIInvokeInterface
{
  _Jv_func reserved0;
  _Jv_func reserved1;
  _Jv_func reserved2;

  jint (JNICALL *DestroyJavaVM)               (JavaVM *);
  jint (JNICALL *AttachCurrentThread)         (JavaVM *, void **, void *);
  jint (JNICALL *DetachCurrentThread)         (JavaVM *);
  jint (JNICALL *GetEnv)                      (JavaVM *, void **, jint);
  /* Added to JNIInvokeInterface in JDK 1.4. */
  jint (JNICALL *AttachCurrentThreadAsDaemon) (JavaVM *, void **, void *);
};

typedef struct JavaVMAttachArgs
{
  jint version;			/* Must be JNI_VERSION_1_2 or later  */
  char *name;			/* The name of the thread (or NULL).  */
  jobject group;		/* Global ref of a ThreadGroup object
				   (or NULL).  */
} JavaVMAttachArgs;

typedef struct JavaVMOption
{
  char *optionString;
  void *extraInfo;
} JavaVMOption;

/**
 * This struct is passed as the 2nd argument to JNI_CreateJavaVM when
 * the caller wants the version 1.2 (or later) JNI interface pointer.
 */
typedef struct JavaVMInitArgs
{
  /* Must be JNI_VERSION_1_2 or later */
  jint version;

  /* Number of options.  */
  jint nOptions;

  /* Options to the VM.  */
  JavaVMOption *options;

  /* Whether we should ignore unrecognized options.  */
  jboolean ignoreUnrecognized;
} JavaVMInitArgs;


/**
 * This struct is passed as the 2nd argument to JNI_CreateJavaVM when
 * the caller wants the version 1.1 JNI interface pointer.
 **/
typedef struct JDK1_1InitArgs {
  /* The first two fields were reserved in JDK 1.1, and
     formally introduced in JDK 1.1.2. */
  /* Java VM version */
  jint version;               /* Must be JNI_VERSION_1_1!! */
  
  /* System properties. */
  char **properties;
  
  /* whether to check the Java source files are newer than 
   * compiled class files. */
  jint checkSource;
  
  /* maximum native stack size of Java-created threads. */
  jint nativeStackSize;
  
  /* maximum Java stack size. */
  jint javaStackSize;
  
  /* initial heap size. */
  jint minHeapSize;
  
  /* maximum heap size. */
  jint maxHeapSize;
  
  /* controls whether Java byte code should be verified:
   * 0 -- none, 1 -- remotely loaded code, 2 -- all code. */
  jint verifyMode;
  
  /* the local directory path for class loading. */
  const char *classpath;
  
  /* a hook for a function that redirects all VM messages. */
  jint (*vfprintf)(FILE *fp, const char *format, 
		   va_list args);
  
  /* a VM exit hook. */
  void (*exit)(jint code);
  
  /* a VM abort hook. */
  void (*abort)();
  
  /* whether to enable class GC. */
  jint enableClassGC;
  
  /* whether GC messages will appear. */
  jint enableVerboseGC;
  
  /* whether asynchronous GC is allowed. */
  jint disableAsyncGC;
  
  /* Three reserved fields. */ 
  jint reserved0;
  jint reserved1;
  jint reserved2;
} JDK1_1InitArgs;


#endif /* __CLASSPATH_JNI_H__ */


/*
 * ... here endeth the expansion.
 */

/* definition for converting doubles to two int32s or one int64 */
typedef union
{
  double d;
  struct
  {
    int32 hi;
    int32 lo;
  } i;
  int64 l;
} tDConv;

/* definition for converting a float to an int32 */
typedef union
{
  float f;
  int32 i;
} tFConv;



#endif /* __KISSME_JNI_H__ */
